/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.stack.metro.metadata;

import com.sun.xml.ws.transport.http.ResourceLoader;

import javax.servlet.ServletContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import java.net.URL;
import java.util.Set;
import java.util.Enumeration;
import java.io.InputStream;

/**
 * This ServletContext implementation provides access to resources only.
 * Other methods are not implemented at all. 
 *
 * @author richard.opalka@jboss.com
 */
public class FakeServletContext implements ServletContext
{
   private ResourceLoader resourceLoader;

   public FakeServletContext(ResourceLoader resourceLoader)
   {
      this.resourceLoader = resourceLoader;
   }

   public URL getResource(String name)
   {
      try
      {
         return resourceLoader.getResource(name);
      }
      catch (Throwable e)
      {
         return null;
      }
   }

   public InputStream getResourceAsStream(String string)
   {
      try
      {
         return getResource(string).openStream();
      }
      catch (Throwable e)
      {
         return null;
      }
   }

   public ServletContext getContext(String string)
   {
      throw new UnsupportedOperationException();
   }

   public String getContextPath()
   {
      throw new UnsupportedOperationException();
   }

   public int getMajorVersion()
   {
      throw new UnsupportedOperationException();
   }

   public int getMinorVersion()
   {
      throw new UnsupportedOperationException();
   }

   public String getMimeType(String string)
   {
      throw new UnsupportedOperationException();
   }

   @SuppressWarnings("unchecked")
   public Set getResourcePaths(String string)
   {
      throw new UnsupportedOperationException();
   }

   public RequestDispatcher getRequestDispatcher(String string)
   {
      throw new UnsupportedOperationException();
   }

   public RequestDispatcher getNamedDispatcher(String string)
   {
      throw new UnsupportedOperationException();
   }

   public Servlet getServlet(String string) throws ServletException
   {
      throw new UnsupportedOperationException();
   }

   @SuppressWarnings("unchecked")
   public Enumeration getServlets()
   {
      throw new UnsupportedOperationException();
   }

   @SuppressWarnings("unchecked")
   public Enumeration getServletNames()
   {
      throw new UnsupportedOperationException();
   }

   public void log(String string)
   {
      // does nothing
   }

   public void log(Exception exception, String string)
   {
      // does nothing
   }

   public void log(String string, Throwable throwable)
   {
      // does nothing
   }

   public String getRealPath(String string)
   {
      throw new UnsupportedOperationException();
   }

   public String getServerInfo()
   {
      throw new UnsupportedOperationException();
   }

   public String getInitParameter(String string)
   {
      throw new UnsupportedOperationException();
   }

   @SuppressWarnings("unchecked")
   public Enumeration getInitParameterNames()
   {
      throw new UnsupportedOperationException();
   }

   public Object getAttribute(String string)
   {
      throw new UnsupportedOperationException();
   }

   @SuppressWarnings("unchecked")
   public Enumeration getAttributeNames()
   {
      throw new UnsupportedOperationException();
   }

   public void setAttribute(String string, Object object)
   {
      throw new UnsupportedOperationException();
   }

   public void removeAttribute(String string)
   {
      throw new UnsupportedOperationException();
   }

   public String getServletContextName()
   {
      throw new UnsupportedOperationException();
   }
}
