/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.metadata.sunjaxws;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.wsf.stack.metro.metadata.sunjaxws.DDHandlerChain;

public class DDEndpoint {
    private String name;
    private String wsdl;
    private QName service;
    private QName port;
    private String implementation;
    private String urlPattern;
    private String binding;
    private boolean enableMTOM;
    private DDHandlerChain handlerChain;
    static final List<String> validBindings = new ArrayList<String>();

    public DDEndpoint(String name, String impl, String urlPattern) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (impl == null || impl.length() == 0) {
            throw new IllegalArgumentException("implementation cannot be null");
        }
        if (urlPattern == null || urlPattern.length() == 0) {
            throw new IllegalArgumentException("urlPattern cannot be null");
        }
        this.name = name;
        this.implementation = impl;
        this.urlPattern = urlPattern;
    }

    public String getName() {
        return this.name;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        if (!validBindings.contains(binding)) {
            throw new IllegalArgumentException("Invalid binding: " + binding);
        }
        this.binding = binding;
    }

    public boolean isEnableMTOM() {
        return this.enableMTOM;
    }

    public void setEnableMTOM(boolean enableMTOM) {
        this.enableMTOM = enableMTOM;
    }

    public QName getPort() {
        return this.port;
    }

    public void setPort(QName port) {
        this.port = port;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public DDHandlerChain getHandlerChain() {
        return this.handlerChain;
    }

    public void setHandlerChain(DDHandlerChain handlerChain) {
        this.handlerChain = handlerChain;
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write("<endpoint");
        writer.write(" name='" + this.name + "'");
        writer.write(" implementation='" + this.implementation + "'");
        writer.write(" url-pattern='" + this.urlPattern + "'");
        if (this.service != null) {
            writer.write(" service='" + this.service + "'");
        }
        if (this.port != null) {
            writer.write(" port='" + this.port + "'");
        }
        if (this.wsdl != null) {
            writer.write(" wsdl='" + this.wsdl + "'");
        }
        if (this.binding != null) {
            writer.write(" binding='" + this.binding + "'");
        }
        writer.write(" enable-mtom='" + this.enableMTOM + "'");
        writer.write(">");
        if (this.handlerChain != null) {
            this.handlerChain.writeTo(writer);
        }
        writer.write("</endpoint>");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Endpoint");
        str.append("\n name=" + this.name);
        str.append("\n implementation=" + this.implementation);
        str.append("\n url-pattern=" + this.urlPattern);
        if (this.service != null) {
            str.append("\n service=" + this.service);
        }
        if (this.port != null) {
            str.append("\n port=" + this.port);
        }
        if (this.wsdl != null) {
            str.append("\n wsdl=" + this.wsdl);
        }
        if (this.binding != null) {
            str.append("\n binding=" + this.binding);
        }
        str.append("\n enable-mtom=" + this.enableMTOM);
        return str.toString();
    }

    static {
        validBindings.add("http://schemas.xmlsoap.org/wsdl/soap/http");
        validBindings.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        validBindings.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        validBindings.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        validBindings.add("http://www.w3.org/2004/08/wsdl/http");
    }
}

