/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.log;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

public class NamespaceFilter
implements Filter {
    private Set<String> namespaces;
    private boolean show;

    public NamespaceFilter(boolean show) {
        this.show = show;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            return true;
        }
        for (String ns : this.namespaces) {
            if (!loggerName.startsWith(ns)) continue;
            return this.show;
        }
        return !this.show;
    }

    public void addNamespace(String ns) {
        if (this.namespaces == null) {
            this.namespaces = new LinkedHashSet<String>();
        }
        this.namespaces.add(ns);
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Set<String> namespaces) {
        this.namespaces = namespaces;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }
}

