/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.stack.metro;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser.AdapterFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Heiko Braun
 */
public class MessageStreamAdapter extends Adapter<MessageStreamAdapter.StreamToolkit>
{
   public static final AdapterFactory<MessageStreamAdapter> FACTORY = new AdapterFactory<MessageStreamAdapter>()
   {
      public MessageStreamAdapter createAdapter(String name, String urlPattern, WSEndpoint<?> endpoint)
      {         
         return new MessageStreamAdapter(endpoint);
      }
   };
   
   public MessageStreamAdapter(WSEndpoint endpoint)
   {
      super(endpoint);
   }

   public void handle(MessageStreamContext context, InputStream in, OutputStream out)
   throws IOException
   {
      MessageStreamConnectionImpl connection = new MessageStreamConnectionImpl(context, in, out);

      StreamToolkit tk = pool.take();
      try
      {
         tk.handle(connection);
         connection.flush();
      }
      finally
      {
         pool.recycle(tk);
         connection.close();
      }
   }

   protected StreamToolkit createToolkit()
   {
      return new StreamToolkit();
   }

   class StreamToolkit extends Adapter.Toolkit implements TransportBackChannel
   {
      private MessageStreamConnectionImpl connection;

      private void handle(MessageStreamConnectionImpl connection)
      throws IOException
      {
         this.connection = connection;
         
         String contentTypeStr = connection.getRequestHeader(MessageStreamContext.CONTENT_TYPE);
         InputStream in = connection.getInputStream();
         Packet packet = new Packet();
         codec.decode(in, contentTypeStr, packet);

         try
         {
            packet = head.process(packet, connection, this);
         }
         catch(Exception e)
         {
            e.printStackTrace();
            connection.setStatus(MessageStreamContext.STATUS_INTERNAL_SERVER_ERROR);
            return;
         }

         contentTypeStr = codec.getStaticContentType(packet).getContentType();
         if (contentTypeStr == null)
         {
            throw new UnsupportedOperationException();
         }
         else
         {
            Map<String, String> headers = new HashMap();
            headers.put(MessageStreamContext.CONTENT_TYPE, contentTypeStr);
            connection.setResponseHeaders(headers);
            codec.encode(packet, connection.getOutputStream());
         }
      }

      public void close()
      {         
         connection.close();
      }
   }
}
