/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.stack.metro;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Heiko Braun
 */
public class MessageStreamConnectionImpl implements WebServiceContextDelegate
{
   private int status;
   private boolean isClosed;
   private InputStream inputStream;
   private OutputStream outputStream;
   private MessageStreamContext messageContext;
   private Map<String, String> requestHeaders = new HashMap<String, String>();
   private Map<String, String> responseHeaders;

   public MessageStreamConnectionImpl(MessageStreamContext context, InputStream in, OutputStream out)
   {
      this.outputStream = out;
      this.inputStream = in;
      this.messageContext = context;
      populateRequestHeaders();
   }

   public int getStatus()
   {
      return this.status;
   }

   public void setStatus(int statusCode)
   {
      this.status = statusCode;
   }

   public Map<String, String> getRequestHeaders()
   {
      return this.requestHeaders;
   }

   public void setRequestHeaders(Map<String, String> requestHeaders)
   {
      this.requestHeaders = requestHeaders;
   }

   public String getRequestHeader(String name)
   {
      return this.requestHeaders.get(name);
   }

   public Map<String, String> getResponseHeaders()
   {
      return this.responseHeaders;
   }

   public void setResponseHeaders(Map<String, String> responseHeaders)
   {
      this.responseHeaders = responseHeaders;
   }

   public InputStream getInputStream()
   {
      return this.inputStream;
   }

   public OutputStream getOutputStream()
   {
      return this.outputStream;
   }

   public void closeInput()
   {
      if (this.inputStream != null)
      {
         try
         {
            this.inputStream.close();
         }
         catch (IOException ignore) {}
         this.inputStream = null;
      }
   }

   public void closeOutput()
   {
      if (this.outputStream != null)
      {
         try
         {
            this.outputStream.close();
         }
         catch (IOException ignore) {}
         this.outputStream = null;
      }
   }

   public void close()
   {
      if (this.isClosed == false)
      {
         synchronized (this)
         {
            if (this.isClosed == false)
            {
               this.isClosed = true;
               closeInput();
               closeOutput();
            }
         }
      }
   }

   public void flush()
   throws IOException
   {
      if (this.outputStream != null)
      {
         this.outputStream.flush();
      }
   }

   public Principal getUserPrincipal(Packet request)
   {
      throw new UnsupportedOperationException();
   }

   public boolean isUserInRole(Packet request, String role)
   {
      throw new UnsupportedOperationException();
   }

   @SuppressWarnings("unchecked")
   public String getEPRAddress(Packet request, WSEndpoint endpoint)
   {
      throw new UnsupportedOperationException();
   }

   @SuppressWarnings("unchecked")
   public String getWSDLAddress(Packet request, WSEndpoint endpoint)
   {
      throw new UnsupportedOperationException();
   }

   private void populateRequestHeaders()
   {
      for(String s : this.messageContext.getRequestContext().keySet())
      {
         this.requestHeaders.put(s, this.messageContext.getRequestContext().get(s));
      }
   }
}
