/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.policy;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.client.SelectOptimalEncodingFeature;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.encoding.policy.EncodingConstants;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.ModelConfiguratorProvider;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;

public class SelectOptimalEncodingModelConfiguratorProvider
implements ModelConfiguratorProvider {
    public static final QName enabled = new QName("enabled");

    public void configure(@NotNull WSDLModel model, @NotNull PolicyMap policyMap) throws PolicyException {
        assert (model != null);
        assert (policyMap != null);
        for (WSDLService service : model.getServices().values()) {
            for (WSDLPort port : service.getPorts()) {
                this.configure(port, policyMap);
            }
        }
    }

    public void configure(@NotNull WSDLPort port, @NotNull PolicyMap policyMap) throws PolicyException {
        assert (port != null);
        assert (policyMap != null);
        PolicyMapKey key = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName());
        Policy policy = policyMap.getEndpointEffectivePolicy(key);
        if (null != policy && policy.contains(EncodingConstants.SELECT_OPTIMAL_ENCODING_ASSERTION)) {
            for (AssertionSet assertionSet : policy) {
                for (PolicyAssertion assertion : assertionSet) {
                    if (!EncodingConstants.SELECT_OPTIMAL_ENCODING_ASSERTION.equals(assertion.getName())) continue;
                    String value = assertion.getAttributeValue(enabled);
                    boolean isSelectOptimalEncodingEnabled = value == null || Boolean.valueOf(value.trim()) != false;
                    port.addFeature((WebServiceFeature)new SelectOptimalEncodingFeature(isSelectOptimalEncodingEnabled));
                }
            }
        }
    }
}

