/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.testing;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.v200702.SequenceElement;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PacketFilter {
    protected static final long UNSPECIFIED = -1L;
    private static final RmLogger LOGGER = RmLogger.getLogger(PacketFilter.class);
    protected final RmVersion rmVersion;

    protected PacketFilter(RmVersion rmVersion) {
        this.rmVersion = rmVersion;
    }

    public abstract Packet filterClientRequest(Packet var1) throws Exception;

    public abstract Packet filterServerResponse(Packet var1) throws Exception;

    protected final String getSequenceId(Packet packet) {
        try {
            if (packet == null || packet.getMessage() == null || packet.getMessage().getHeaders() == null) {
                return null;
            }
            HeaderList headers = packet.getMessage().getHeaders();
            switch (this.rmVersion) {
                case WSRM10: {
                    com.sun.xml.ws.rm.v200502.SequenceElement se = (com.sun.xml.ws.rm.v200502.SequenceElement)this.readHeader(headers, "Sequence");
                    return se != null ? se.getIdentifier().toString() : null;
                }
                case WSRM11: {
                    SequenceElement se = (SequenceElement)this.readHeader(headers, "Sequence");
                    return se != null ? se.getId() : null;
                }
            }
            LOGGER.severe("Unsupported RM version [" + this.rmVersion.namespaceUri + "]");
            return null;
        }
        catch (Exception ex) {
            LOGGER.warning("Unexpected exception occured", ex);
            return null;
        }
    }

    protected final long getMessageId(Packet packet) {
        try {
            if (packet == null || packet.getMessage() == null || packet.getMessage().getHeaders() == null) {
                return -1L;
            }
            HeaderList headers = packet.getMessage().getHeaders();
            switch (this.rmVersion) {
                case WSRM10: {
                    com.sun.xml.ws.rm.v200502.SequenceElement se = (com.sun.xml.ws.rm.v200502.SequenceElement)this.readHeader(headers, "Sequence");
                    return se != null ? se.getMessageNumber() : -1L;
                }
                case WSRM11: {
                    SequenceElement se = (SequenceElement)this.readHeader(headers, "Sequence");
                    return se != null ? se.getMessageNumber() : -1L;
                }
            }
            LOGGER.severe("Unsupported RM version [" + this.rmVersion.namespaceUri + "]");
            return -1L;
        }
        catch (Exception ex) {
            LOGGER.warning("Unexpected exception occured", ex);
            return -1L;
        }
    }

    private <T> T readHeader(HeaderList headers, String name) throws JAXBException, XMLStreamException {
        Header header = headers.get(this.rmVersion.namespaceUri, name, false);
        if (header == null) {
            return (T)((Object)null);
        }
        return (T)this.rmVersion.jaxbUnmarshaller.unmarshal(header.readHeader());
    }
}

