/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.client;

import com.sun.xml.ws.addressing.policy.Address;
import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.client.STSIssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.SecondaryIssuedTokenParameters;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.policy.IssuedToken;
import com.sun.xml.ws.security.policy.Issuer;
import com.sun.xml.ws.security.policy.RequestSecurityTokenTemplate;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.impl.client.SecondaryIssuedTokenParametersImpl;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;

public class DefaultSTSIssuedTokenConfiguration
extends STSIssuedTokenConfiguration {
    private static final String PRE_CONFIGURED_STS = "PreconfiguredSTS";
    private static final String NAMESPACE = "namespace";
    private static final String CONFIG_NAMESPACE = "";
    private static final String ENDPOINT = "endPoint";
    private static final String METADATA = "metadata";
    private static final String WSDL_LOCATION = "wsdlLocation";
    private static final String SERVICE_NAME = "serviceName";
    private static final String PORT_NAME = "portName";
    private static final String REQUEST_SECURITY_TOKEN_TEMPLATE = "RequestSecurityTokenTemplate";
    private static final String CLAIMS = "Claims";
    private static final String DIALECT = "Dialect";
    private static final String IDENTITY = "Identity";
    private static final String WST_VERSION = "wstVersion";
    private String tokenType = null;
    private String keyType = null;
    private long keySize = -1L;
    private String signatureAlg = null;
    private String encAlg = null;
    private String canAlg = null;
    private String keyWrapAlg = null;
    private Token oboToken = null;
    private String signWith = null;
    private String encryptWith = null;
    private Claims claims = null;

    public DefaultSTSIssuedTokenConfiguration(String protocol, IssuedToken issuedToken, PolicyAssertion localToken) {
        if (protocol != null) {
            this.protocol = protocol;
        }
        this.parseAssertions(issuedToken, localToken);
    }

    public DefaultSTSIssuedTokenConfiguration(String stsEndpoint, String stsMEXAddress) {
        super(stsEndpoint, stsMEXAddress);
    }

    public DefaultSTSIssuedTokenConfiguration(String stsEndpoint, String stsWSDLLocation, String stsServiceName, String stsPortName, String stsNamespace) {
        super(stsEndpoint, stsWSDLLocation, stsServiceName, stsPortName, stsNamespace);
    }

    public DefaultSTSIssuedTokenConfiguration(String protocol, String stsEndpoint, String stsMEXAddress) {
        super(protocol, stsEndpoint, stsMEXAddress);
    }

    public DefaultSTSIssuedTokenConfiguration(String protocol, String stsEndpoint, String stsWSDLLocation, String stsServiceName, String stsPortName, String stsNamespace) {
        super(protocol, stsEndpoint, stsWSDLLocation, stsServiceName, stsPortName, stsNamespace);
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setKeySize(long keySize) {
        this.keySize = keySize;
    }

    public void setSignWith(String signWithAlg) {
        this.signWith = signWithAlg;
    }

    public void setEncryptWith(String encWithAlg) {
        this.encryptWith = encWithAlg;
    }

    public void setSignatureAlgorithm(String sigAlg) {
        this.signatureAlg = sigAlg;
    }

    public void setEncryptionAlgorithm(String encAlg) {
        this.encAlg = encAlg;
    }

    public void setCanonicalizationAlgorithm(String canAlg) {
        this.canAlg = canAlg;
    }

    public void setKeyWrapAlgorithm(String keyWrapAlg) {
        this.keyWrapAlg = keyWrapAlg;
    }

    public void setClaims(Claims claims) {
        this.claims = claims;
    }

    public void setOBOToken(Token token) {
        this.oboToken = token;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public long getKeySize() {
        return this.keySize;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlg;
    }

    public String getEncryptionAlgorithm() {
        return this.encAlg;
    }

    public String getCanonicalizationAlgorithm() {
        return this.canAlg;
    }

    public String getKeyWrapAlgorithm() {
        return this.keyWrapAlg;
    }

    public String getSignWith() {
        return this.signWith;
    }

    public String getEncryptWith() {
        return this.encryptWith;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public Token getOBOToken() {
        return this.oboToken;
    }

    public void setSecondaryIssuedTokenParameters(SecondaryIssuedTokenParameters sisPara) {
        this.sisPara = sisPara;
    }

    private void parseAssertions(IssuedToken issuedToken, PolicyAssertion localToken) {
        RequestSecurityTokenTemplate rstt;
        Issuer issuer = issuedToken.getIssuer();
        URI stsURI = null;
        if (issuer != null) {
            stsURI = issuedToken.getIssuer().getAddress().getURI();
            if (issuer.getIdentity() != null) {
                this.getOtherOptions().put(IDENTITY, issuer.getIdentity());
            }
        }
        if (stsURI != null) {
            URI metadataIssuerAddressURI;
            this.stsEndpoint = stsURI.toString();
            Address metadataIssuerAddress = issuer.getMetadataAddress();
            if (metadataIssuerAddress != null && (metadataIssuerAddressURI = metadataIssuerAddress.getURI()) != null) {
                this.stsMEXAddress = metadataIssuerAddressURI.toString();
            }
            if (this.stsMEXAddress == null) {
                this.stsMEXAddress = this.stsEndpoint + "/mex";
            }
        }
        String stsProtocol = null;
        if (localToken != null && PRE_CONFIGURED_STS.equals(localToken.getName().getLocalPart())) {
            Map attrs = localToken.getAttributes();
            stsProtocol = (String)attrs.get(new QName(CONFIG_NAMESPACE, WST_VERSION));
            if (stsURI == null) {
                this.stsNamespace = (String)attrs.get(new QName(CONFIG_NAMESPACE, NAMESPACE));
                this.stsEndpoint = (String)attrs.get(new QName(CONFIG_NAMESPACE, ENDPOINT));
                if (this.stsEndpoint == null) {
                    this.stsEndpoint = (String)attrs.get(new QName(CONFIG_NAMESPACE, ENDPOINT.toLowerCase()));
                }
                this.stsMEXAddress = (String)attrs.get(new QName(CONFIG_NAMESPACE, METADATA));
                if (this.stsMEXAddress == null) {
                    this.stsWSDLLocation = (String)attrs.get(new QName(CONFIG_NAMESPACE, WSDL_LOCATION));
                    this.stsServiceName = (String)attrs.get(new QName(CONFIG_NAMESPACE, SERVICE_NAME));
                    this.stsPortName = (String)attrs.get(new QName(CONFIG_NAMESPACE, PORT_NAME));
                }
            }
        }
        if (stsProtocol == null) {
            stsProtocol = this.protocol;
        }
        if ((rstt = issuedToken.getRequestSecurityTokenTemplate()) != null) {
            Claims claims = null;
            if (this.protocol.equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
                if (issuedToken.getClaims() != null) {
                    claims = this.getClaims(issuedToken, stsProtocol);
                }
            } else if (rstt.getClaims() != null) {
                claims = this.getClaims(issuedToken, stsProtocol);
            }
            if (!this.protocol.equals(stsProtocol)) {
                this.copy(rstt, stsProtocol, this.protocol);
                this.setClaims(claims);
                this.protocol = stsProtocol;
            } else if (this.protocol.equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
                SecondaryIssuedTokenParametersImpl sitp = new SecondaryIssuedTokenParametersImpl();
                this.copy(rstt, sitp);
                sitp.setClaims(claims);
                this.sisPara = sitp;
            } else {
                this.copy(rstt);
                this.setClaims(claims);
            }
        }
    }

    private Claims getClaims(IssuedToken issuedToken, String stsWstProtocol) {
        Claims cs = null;
        try {
            Element claimsEle = null;
            if (this.protocol.equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
                claimsEle = issuedToken.getClaims().getClaimsAsElement();
            } else {
                RequestSecurityTokenTemplate rstt = issuedToken.getRequestSecurityTokenTemplate();
                claimsEle = rstt.getClaims().getClaimsAsElement();
            }
            cs = WSTrustElementFactory.newInstance(WSTrustVersion.getInstance(stsWstProtocol)).createClaims(claimsEle);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        return cs;
    }

    private void copy(RequestSecurityTokenTemplate rstt) {
        this.setTokenType(rstt.getTokenType());
        this.setKeyType(rstt.getKeyType());
        this.setKeySize(rstt.getKeySize());
        this.setSignWith(rstt.getSignWith());
        this.setEncryptWith(rstt.getEncryptWith());
        this.setSignatureAlgorithm(rstt.getSignatureAlgorithm());
        this.setEncryptionAlgorithm(rstt.getEncryptionAlgorithm());
        this.setCanonicalizationAlgorithm(rstt.getCanonicalizationAlgorithm());
    }

    private void copy(RequestSecurityTokenTemplate rstt, SecondaryIssuedTokenParametersImpl sitp) {
        sitp.setTokenType(rstt.getTokenType());
        sitp.setKeyType(rstt.getKeyType());
        sitp.setKeySize(rstt.getKeySize());
        sitp.setSignWith(rstt.getSignWith());
        sitp.setEncryptWith(rstt.getEncryptWith());
        sitp.setSignatureAlgorithm(rstt.getSignatureAlgorithm());
        sitp.setEncryptionAlgorithm(rstt.getEncryptionAlgorithm());
        sitp.setCanonicalizationAlgorithm(rstt.getCanonicalizationAlgorithm());
        sitp.setKeyWrapAlgorithm(rstt.getKeyWrapAlgorithm());
    }

    private void copy(RequestSecurityTokenTemplate rstt, String stsWstProtocol, String serviceWstProtocol) {
        WSTrustVersion stsWstVer = WSTrustVersion.getInstance(stsWstProtocol);
        WSTrustVersion serviceWstVer = WSTrustVersion.getInstance(serviceWstProtocol);
        String rsttKeyType = rstt.getKeyType();
        if (serviceWstVer.getPublicKeyTypeURI().equals(rsttKeyType)) {
            this.setKeyType(stsWstVer.getPublicKeyTypeURI());
        } else if (serviceWstVer.getSymmetricKeyTypeURI().equals(rsttKeyType)) {
            this.setKeyType(stsWstVer.getSymmetricKeyTypeURI());
        } else if (serviceWstVer.getBearerKeyTypeURI().equals(rsttKeyType)) {
            this.setKeyType(stsWstVer.getBearerKeyTypeURI());
        }
        this.setTokenType(rstt.getTokenType());
        this.setKeySize(rstt.getKeySize());
        this.setSignWith(rstt.getSignWith());
        this.setEncryptWith(rstt.getEncryptWith());
        this.setSignatureAlgorithm(rstt.getSignatureAlgorithm());
        this.setEncryptionAlgorithm(rstt.getEncryptionAlgorithm());
        this.setCanonicalizationAlgorithm(rstt.getCanonicalizationAlgorithm());
    }
}

