/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.plugins.tools;

import java.io.File;
import java.net.URLClassLoader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jboss.ws.plugins.tools.AbstractToolsMojo;
import org.jboss.ws.plugins.tools.WSContractDelegate;
import org.jboss.ws.plugins.tools.WSContractProviderParams;

public abstract class AbstractWsProvideMojo
extends AbstractToolsMojo {
    private boolean generateWsdl;
    protected File resourceDirectory;
    protected File sourceDirectory;
    private String endpointClass;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (this.endpointClass == null) {
            this.getLog().info((CharSequence)"No service endpoint implementation class specified, nothing to do.");
            return;
        }
        if (this.verbose.booleanValue()) {
            log.info((CharSequence)"Classpath:");
            for (String s : this.getClasspathElements()) {
                log.info((CharSequence)(" " + s));
            }
        }
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = this.getMavenClasspathAwareClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            WSContractProviderParams params = new WSContractProviderParams();
            params.setEndpointClass(this.endpointClass);
            params.setExtension(this.extension);
            params.setGenerateSource(this.generateSource);
            params.setGenerateWsdl(this.generateWsdl);
            params.setLoader(loader);
            params.setOutputDirectory(this.getOutputDirectory());
            params.setResourceDirectory(this.resourceDirectory);
            params.setSourceDirectory(this.sourceDirectory);
            params.setFork(this.fork);
            params.setArgLine(this.argLine);
            WSContractDelegate delegate = new WSContractDelegate(this.getLog());
            delegate.runProvider(params);
            this.updateProjectSourceRoots();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while running wsprovide", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    public boolean isGenerateWsdl() {
        return this.generateWsdl;
    }

    public File getResourceDirectory() {
        return this.resourceDirectory;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getEndpointClass() {
        return this.endpointClass;
    }
}

