/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.xnio.IoFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIoFuture<T>
implements IoFuture<T> {
    private Object lock = new Object();
    private IoFuture.Status status = IoFuture.Status.WAITING;
    private Object result;
    private List<IoFuture.Notifier<T>> notifierList;

    protected AbstractIoFuture() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status getStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status await() {
        Object object = this.lock;
        synchronized (object) {
            boolean intr = false;
            try {
                while (this.status == IoFuture.Status.WAITING) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public IoFuture.Status await(TimeUnit timeUnit, long time) {
        if (time < 0L) {
            time = 0L;
        }
        if ((deadline = (duration = timeUnit.toMillis(time)) + System.currentTimeMillis()) < 0L) {
            deadline = 0x7FFFFFFFFFFFFFFFL;
        }
        var8_5 = this.lock;
        synchronized (var8_5) {
            block17: {
                intr = false;
                while (true) lbl-1000:
                // 3 sources

                {
                    if (this.status != IoFuture.Status.WAITING) break block17;
                    try {
                        this.lock.wait(duration);
                    }
                    catch (InterruptedException e) {
                        block18: {
                            intr = true;
                            if ((duration = deadline - System.currentTimeMillis()) > 0L) continue;
                            var10_9 = IoFuture.Status.TIMED_OUT;
                            if (!intr) break block18;
                            Thread.currentThread().interrupt();
                        }
                        return var10_9;
                        {
                            catch (Throwable var11_10) {
                                block19: {
                                    block20: {
                                        duration = deadline - System.currentTimeMillis();
                                        if (duration > 0L) break block19;
                                        var12_11 = IoFuture.Status.TIMED_OUT;
                                        if (!intr) break block20;
                                        Thread.currentThread().interrupt();
                                    }
                                    return var12_11;
                                }
                                throw var11_10;
                            }
                        }
                    }
                    duration = deadline - System.currentTimeMillis();
                    if (duration > 0L) ** GOTO lbl-1000
                    var10_8 = IoFuture.Status.TIMED_OUT;
                    return var10_8;
                    break;
                }
                finally {
                    if (intr) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status awaitInterruptably() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.status == IoFuture.Status.WAITING) {
                this.lock.wait();
            }
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status awaitInterruptably(TimeUnit timeUnit, long time) throws InterruptedException {
        long duration;
        long deadline;
        if (time < 0L) {
            time = 0L;
        }
        if ((deadline = (duration = timeUnit.toMillis(time)) + System.currentTimeMillis()) < 0L) {
            deadline = Long.MAX_VALUE;
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.status == IoFuture.Status.WAITING) {
                this.lock.wait(duration);
                duration = deadline - System.currentTimeMillis();
                if (duration > 0L) continue;
                return IoFuture.Status.TIMED_OUT;
            }
            return this.status;
        }
    }

    @Override
    public T get() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            switch (this.await()) {
                case DONE: {
                    return (T)this.result;
                }
                case FAILED: {
                    throw (IOException)this.result;
                }
            }
            throw new IllegalStateException("Unexpected state " + (Object)((Object)this.status));
        }
    }

    @Override
    public T getInterruptably() throws IOException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            switch (this.awaitInterruptably()) {
                case DONE: {
                    return (T)this.result;
                }
                case FAILED: {
                    throw (IOException)this.result;
                }
            }
            throw new IllegalStateException("Unexpected state " + (Object)((Object)this.status));
        }
    }

    @Override
    public IOException getException() throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.FAILED) {
                return (IOException)this.result;
            }
            throw new IllegalStateException("getException() when state is not FAILED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotifier(IoFuture.Notifier<T> notifier) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                if (this.notifierList == null) {
                    this.notifierList = new ArrayList<IoFuture.Notifier<T>>();
                }
                this.notifierList.add(notifier);
            } else {
                this.runNotifier(notifier);
            }
        }
    }

    private final void runAllNotifiers() {
        if (this.notifierList != null) {
            Iterator<IoFuture.Notifier<T>> it = this.notifierList.iterator();
            while (it.hasNext()) {
                IoFuture.Notifier<T> notifier = it.next();
                this.runNotifier(notifier);
                it.remove();
            }
            this.notifierList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setException(IOException exception) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                this.status = IoFuture.Status.FAILED;
                this.result = exception;
                this.runAllNotifiers();
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setResult(T result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                this.status = IoFuture.Status.DONE;
                this.result = result;
                this.runAllNotifiers();
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishCancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                this.status = IoFuture.Status.CANCELLED;
                this.runAllNotifiers();
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    @Override
    public abstract IoFuture<T> cancel();

    protected abstract void runNotifier(IoFuture.Notifier<T> var1);
}

