/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer[] buffers;
    private int position = 0;

    private static ByteBuffer[] unroll(Iterator<ByteBuffer> byteBuffers, int count) {
        if (byteBuffers.hasNext()) {
            ByteBuffer buffer = byteBuffers.next();
            ByteBuffer[] bufs = ByteBufferInputStream.unroll(byteBuffers, count + 1);
            bufs[count] = buffer;
            return bufs;
        }
        return new ByteBuffer[count];
    }

    public ByteBufferInputStream(Iterator<ByteBuffer> buffers) {
        this(ByteBufferInputStream.unroll(buffers, 0));
    }

    public ByteBufferInputStream(Iterable<ByteBuffer> buffers) {
        this(buffers.iterator());
    }

    public ByteBufferInputStream(ByteBuffer buffer) {
        this(new ByteBuffer[]{buffer});
    }

    public ByteBufferInputStream(ByteBuffer[] buffers) {
        this.buffers = buffers;
    }

    @Override
    public int read(byte[] bytes, int offs, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int cnt = 0;
        while (this.position < this.buffers.length) {
            ByteBuffer buffer = this.buffers[this.position];
            if (!buffer.hasRemaining()) {
                ++this.position;
                continue;
            }
            int size = Math.min(buffer.remaining(), len - cnt);
            buffer.get(bytes, offs + cnt, size);
            if ((cnt += size) != len) continue;
            break;
        }
        return cnt == 0 ? -1 : cnt;
    }

    @Override
    public int read() throws IOException {
        while (this.position < this.buffers.length) {
            ByteBuffer buffer = this.buffers[this.position];
            if (buffer.hasRemaining()) {
                return buffer.get() & 0xFF;
            }
            ++this.position;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        long cnt = 0L;
        while (this.position < this.buffers.length) {
            ByteBuffer buffer = this.buffers[this.position];
            if (!buffer.hasRemaining()) {
                ++this.position;
                continue;
            }
            int size = (int)Math.min((long)buffer.remaining(), n - cnt);
            buffer.position(buffer.position() + size);
            if (cnt != n) continue;
            break;
        }
        return cnt;
    }

    @Override
    public int available() throws IOException {
        int remaining = 0;
        for (int i = this.position; i < this.buffers.length; ++i) {
            if ((remaining += this.buffers[i].remaining()) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return remaining;
    }

    @Override
    public void close() throws IOException {
        this.position = this.buffers.length;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException("mark()");
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("reset()");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

