/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.jboss.xnio.BufferAllocator;
import org.jboss.xnio.ObjectSink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer current;
    private final BufferAllocator<ByteBuffer> bufferAllocator;
    private final ObjectSink<ByteBuffer> bufferSink;
    private long count = 0L;
    private final long writeLimit;

    public ByteBufferOutputStream(BufferAllocator<ByteBuffer> bufferAllocator, ObjectSink<ByteBuffer> bufferSink, long writeLimit) {
        this.bufferAllocator = bufferAllocator;
        this.writeLimit = writeLimit;
        this.bufferSink = bufferSink;
    }

    @Override
    public void write(byte[] bytes, int offs, int len) throws IOException {
        if ((long)len > this.writeLimit - this.count) {
            throw new BufferOverflowException();
        }
        while (len > 0) {
            if (this.current == null) {
                this.current = this.bufferAllocator.allocate();
            } else if (!this.current.hasRemaining()) {
                ByteBuffer current = this.current;
                this.current = null;
                this.bufferSink.accept(current);
                this.current = this.bufferAllocator.allocate();
            }
            int size = Math.min(len, this.current.remaining());
            this.current.put(bytes, offs, size);
            offs += size;
            len -= size;
            this.count += (long)size;
        }
    }

    @Override
    public void write(int data) throws IOException {
        if (this.count >= this.writeLimit) {
            throw new BufferOverflowException();
        }
        if (!this.current.hasRemaining()) {
            ByteBuffer current = this.current;
            this.current = null;
            this.bufferSink.accept(current);
            this.current = this.bufferAllocator.allocate();
        }
        this.current.put((byte)data);
        ++this.count;
    }

    @Override
    public void flush() throws IOException {
        ByteBuffer current = this.current;
        this.current = null;
        this.bufferSink.accept(current);
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    public long getSize() {
        return this.count;
    }

    public long getRemaining() {
        return this.writeLimit - this.count;
    }
}

