/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jboss.xnio.ObjectSink;
import org.jboss.xnio.ObjectSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Streams {
    private Streams() {
    }

    public static <T> ObjectSink<T> getCollectionObjectSink(Collection<T> target) {
        return new CollectionObjectSink<T>(target);
    }

    public static <T> ObjectSource<T> getIteratorObjectSource(Iterator<T> iterator) {
        return new IteratorObjectSource<T>(iterator);
    }

    public static <T> ObjectSource<T> getEnumerationObjectSource(Enumeration<T> enumeration) {
        return new EnumerationObjectSource<T>(enumeration);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumerationObjectSource<T>
    implements ObjectSource<T> {
        private final Enumeration<T> src;

        public EnumerationObjectSource(Enumeration<T> src) {
            this.src = src;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.src.hasMoreElements();
        }

        @Override
        public T next() throws IOException {
            try {
                return this.src.nextElement();
            }
            catch (NoSuchElementException ex) {
                EOFException eex = new EOFException("Read past end of enumeration");
                eex.setStackTrace(ex.getStackTrace());
                throw eex;
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IteratorObjectSource<T>
    implements ObjectSource<T> {
        private final Iterator<T> src;

        public IteratorObjectSource(Iterator<T> src) {
            this.src = src;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.src.hasNext();
        }

        @Override
        public T next() throws IOException {
            try {
                return this.src.next();
            }
            catch (NoSuchElementException ex) {
                EOFException eex = new EOFException("Iteration past end of iterator");
                eex.setStackTrace(ex.getStackTrace());
                throw eex;
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CollectionObjectSink<T>
    implements ObjectSink<T> {
        private final Collection<T> target;

        public CollectionObjectSink(Collection<T> target) {
            this.target = target;
        }

        @Override
        public void accept(T instance) throws IOException {
            this.target.add(instance);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

