/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.core.nio.BioDatagramChannelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BioMulticastChannelImpl
extends BioDatagramChannelImpl
implements UdpChannel {
    private final MulticastSocket multicastSocket;
    private static final Set<ChannelOption<?>> OPTIONS;

    protected BioMulticastChannelImpl(int sendBufSize, int recvBufSize, Executor handlerExecutor, IoHandler<? super UdpChannel> handler, MulticastSocket multicastSocket) {
        super(sendBufSize, recvBufSize, handlerExecutor, handler, multicastSocket);
        this.multicastSocket = multicastSocket;
    }

    @Override
    public UdpChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        return new BioKey(iface, group);
    }

    @Override
    public UdpChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source) throws IOException {
        throw new UnsupportedOperationException("source filtering not supported");
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.MULTICAST_TTL).equals(option)) {
            return (T)Integer.valueOf(this.multicastSocket.getTimeToLive());
        }
        return super.getOption(option);
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return OPTIONS;
    }

    @Override
    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.MULTICAST_TTL).equals(option)) {
            this.multicastSocket.setTimeToLive((Integer)value);
            return this;
        }
        return super.setOption(option, value);
    }

    static {
        HashSet options = new HashSet(BioDatagramChannelImpl.OPTIONS);
        options.add(CommonOptions.MULTICAST_TTL);
        OPTIONS = Collections.unmodifiableSet(options);
    }

    private final class BioKey
    implements UdpChannel.Key {
        private final AtomicBoolean openFlag = new AtomicBoolean(true);
        private final NetworkInterface networkInterface;
        private final InetAddress group;

        private BioKey(NetworkInterface networkInterface, InetAddress group) throws IOException {
            this.networkInterface = networkInterface;
            this.group = group;
            BioMulticastChannelImpl.this.multicastSocket.joinGroup(new InetSocketAddress(group, 0), networkInterface);
        }

        public UdpChannel.Key block(InetAddress source) throws IOException {
            throw new UnsupportedOperationException("source filtering not supported");
        }

        public UdpChannel.Key unblock(InetAddress source) throws IOException {
            return this;
        }

        public UdpChannel getChannel() {
            return BioMulticastChannelImpl.this;
        }

        public InetAddress getGroup() {
            return this.group;
        }

        public NetworkInterface getNetworkInterface() {
            return this.networkInterface;
        }

        public InetAddress getSourceAddress() {
            return null;
        }

        public boolean isOpen() {
            return this.openFlag.get();
        }

        public void close() throws IOException {
            if (this.openFlag.getAndSet(false)) {
                BioMulticastChannelImpl.this.multicastSocket.leaveGroup(new InetSocketAddress(this.group, 0), this.networkInterface);
            }
        }
    }
}

