/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Pipe;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.core.nio.NioHandle;
import org.jboss.xnio.core.nio.NioProvider;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.spi.SpiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioPipeChannelImpl
implements StreamChannel {
    public static final Logger log = Logger.getLogger(NioPipeChannelImpl.class);
    private final Pipe.SourceChannel sourceChannel;
    private final Pipe.SinkChannel sinkChannel;
    private final IoHandler<? super StreamChannel> handler;
    private final NioHandle sourceHandle;
    private final NioHandle sinkHandle;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private final NioProvider nioProvider;

    public NioPipeChannelImpl(Pipe.SourceChannel sourceChannel, Pipe.SinkChannel sinkChannel, IoHandler<? super StreamChannel> handler, NioProvider nioProvider) throws IOException {
        this.sourceChannel = sourceChannel;
        this.sinkChannel = sinkChannel;
        this.handler = handler;
        this.nioProvider = nioProvider;
        this.sourceHandle = nioProvider.addReadHandler(sourceChannel, new ReadHandler());
        this.sinkHandle = nioProvider.addWriteHandler(sinkChannel, new WriteHandler());
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.sinkChannel.write(srcs, offset, length);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.sinkChannel.write(srcs);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.sinkChannel.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.sourceChannel.isOpen() && this.sinkChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        IoUtils.safeClose(this.sourceChannel);
        try {
            this.sinkChannel.close();
        }
        finally {
            this.nioProvider.removeChannel(this);
            if (!this.callFlag.getAndSet(true)) {
                SpiUtils.handleClosed(this.handler, this);
            }
            this.sinkHandle.cancelKey();
            this.sourceHandle.cancelKey();
        }
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.sourceChannel.read(dsts, offset, length);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.sourceChannel.read(dsts);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.sourceChannel.read(dst);
    }

    @Override
    public void suspendReads() {
        try {
            this.sourceHandle.getSelectionKey().interestOps(0).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void suspendWrites() {
        try {
            this.sinkHandle.getSelectionKey().interestOps(0).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void resumeReads() {
        try {
            this.sourceHandle.getSelectionKey().interestOps(1).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void resumeWrites() {
        try {
            this.sinkHandle.getSelectionKey().interestOps(4).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void shutdownReads() throws IOException {
        this.sourceChannel.close();
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.sinkChannel.close();
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return Collections.emptySet();
    }

    @Override
    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    private class WriteHandler
    implements Runnable {
        private WriteHandler() {
        }

        public void run() {
            IoHandler handler = NioPipeChannelImpl.this.handler;
            try {
                handler.handleWritable(NioPipeChannelImpl.this);
            }
            catch (Throwable t) {
                log.error(t, "Write handler threw an exception", new Object[0]);
            }
        }
    }

    private class ReadHandler
    implements Runnable {
        private ReadHandler() {
        }

        public void run() {
            IoHandler handler = NioPipeChannelImpl.this.handler;
            try {
                handler.handleReadable(NioPipeChannelImpl.this);
            }
            catch (Throwable t) {
                log.error(t, "Read handler threw an exception", new Object[0]);
            }
        }
    }
}

