/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.ConfigurableFactory;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.TcpClient;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.core.nio.NioProvider;
import org.jboss.xnio.spi.Lifecycle;
import org.jboss.xnio.spi.Provider;
import org.jboss.xnio.spi.TcpConnectorService;
import org.jboss.xnio.spi.TcpServerService;
import org.jboss.xnio.spi.UdpServerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Xnio
implements Closeable {
    private final Provider provider;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Object lifecycleLock;

    private Xnio(Provider provider, Object lifecycleLock) {
        this.provider = provider;
        this.lifecycleLock = lifecycleLock;
    }

    public static Xnio createNio() throws IOException {
        return Xnio.createNio(1, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xnio createNio(int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        NioProvider nioProvider;
        Object lifecycleLock;
        Object object = lifecycleLock = new Object();
        synchronized (object) {
            nioProvider = new NioProvider();
            nioProvider.setExecutor(IoUtils.directExecutor());
            nioProvider.setReadSelectorThreads(readSelectorThreads);
            nioProvider.setWriteSelectorThreads(writeSelectorThreads);
            nioProvider.setConnectionSelectorThreads(connectSelectorThreads);
            nioProvider.start();
        }
        return new Xnio(nioProvider, lifecycleLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xnio createNio(Executor handlerExecutor, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        NioProvider nioProvider;
        Object lifecycleLock;
        Object object = lifecycleLock = new Object();
        synchronized (object) {
            nioProvider = new NioProvider();
            nioProvider.setExecutor(handlerExecutor);
            nioProvider.setReadSelectorThreads(readSelectorThreads);
            nioProvider.setWriteSelectorThreads(writeSelectorThreads);
            nioProvider.setConnectionSelectorThreads(connectSelectorThreads);
            nioProvider.start();
        }
        return new Xnio(nioProvider, lifecycleLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xnio createNio(Executor handlerExecutor, ThreadFactory selectorThreadFactory, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        NioProvider nioProvider;
        Object lifecycleLock;
        Object object = lifecycleLock = new Object();
        synchronized (object) {
            nioProvider = new NioProvider();
            nioProvider.setExecutor(handlerExecutor);
            nioProvider.setSelectorThreadFactory(selectorThreadFactory);
            nioProvider.setReadSelectorThreads(readSelectorThreads);
            nioProvider.setWriteSelectorThreads(writeSelectorThreads);
            nioProvider.setConnectionSelectorThreads(connectSelectorThreads);
            nioProvider.start();
        }
        return new Xnio(nioProvider, lifecycleLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableFactory<Closeable> createTcpServer(Executor executor, IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        TcpServerService tcpServerService;
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (bindAddresses == null) {
            throw new NullPointerException("bindAddresses is null");
        }
        if (bindAddresses.length == 0) {
            throw new IllegalArgumentException("no bind addresses specified");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            tcpServerService = this.provider.createTcpServer();
            if (executor != null) {
                tcpServerService.setExecutor(executor);
            }
            tcpServerService.setBindAddresses(bindAddresses);
            tcpServerService.setHandlerFactory(handlerFactory);
        }
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, tcpServerService, started, new LifecycleCloseable(tcpServerService, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableFactory<Closeable> createTcpServer(IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        TcpServerService tcpServerService;
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (bindAddresses == null) {
            throw new NullPointerException("bindAddresses is null");
        }
        if (bindAddresses.length == 0) {
            throw new IllegalArgumentException("no bind addresses specified");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            tcpServerService = this.provider.createTcpServer();
            tcpServerService.setBindAddresses(bindAddresses);
            tcpServerService.setHandlerFactory(handlerFactory);
        }
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, tcpServerService, started, new LifecycleCloseable(tcpServerService, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableFactory<TcpConnector> createTcpConnector(Executor executor) {
        TcpConnectorService connectorService;
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            connectorService = this.provider.createTcpConnector();
            connectorService.setExecutor(executor);
        }
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, connectorService, started, new LifecycleConnector(this, connectorService, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableFactory<TcpConnector> createTcpConnector() {
        TcpConnectorService connectorService;
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            connectorService = this.provider.createTcpConnector();
        }
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, connectorService, started, new LifecycleConnector(this, connectorService, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableFactory<Closeable> createUdpServer(Executor executor, boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        UdpServerService serverService;
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (bindAddresses == null) {
            throw new NullPointerException("bindAddresses is null");
        }
        if (bindAddresses.length == 0) {
            throw new IllegalArgumentException("no bind addresses specified");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            serverService = multicast ? this.provider.createMulticastUdpServer() : this.provider.createUdpServer();
            serverService.setBindAddresses(bindAddresses);
            serverService.setHandlerFactory(handlerFactory);
        }
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, serverService, started, new LifecycleCloseable(serverService, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableFactory<Closeable> createUdpServer(boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        UdpServerService serverService;
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (bindAddresses == null) {
            throw new NullPointerException("bindAddresses is null");
        }
        if (bindAddresses.length == 0) {
            throw new IllegalArgumentException("no bind addresses specified");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            serverService = multicast ? this.provider.createMulticastUdpServer() : this.provider.createUdpServer();
            serverService.setBindAddresses(bindAddresses);
            serverService.setHandlerFactory(handlerFactory);
        }
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, serverService, started, new LifecycleCloseable(serverService, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            Object object = this.lifecycleLock;
            synchronized (object) {
                this.provider.stop();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleConfigurableFactory<Q, Z extends Configurable & Lifecycle>
    implements ConfigurableFactory<Q> {
        private final AtomicBoolean started;
        private final Q resource;
        private final Z configurableLifecycle;
        final /* synthetic */ Xnio this$0;

        private SimpleConfigurableFactory(Z configurableLifecycle, AtomicBoolean started, Q resource) {
            this.this$0 = var1_1;
            this.started = started;
            this.resource = resource;
            this.configurableLifecycle = configurableLifecycle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Q create() throws IOException {
            if (this.started.get()) {
                throw new IllegalStateException("Already created");
            }
            Object object = this.this$0.lifecycleLock;
            synchronized (object) {
                ((Lifecycle)this.configurableLifecycle).start();
            }
            return this.resource;
        }

        @Override
        public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
            return this.configurableLifecycle.getOption(option);
        }

        @Override
        public Set<ChannelOption<?>> getOptions() {
            return this.configurableLifecycle.getOptions();
        }

        @Override
        public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
            if (this.started.get()) {
                throw new IllegalStateException("Already created");
            }
            this.configurableLifecycle.setOption(option, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LifecycleConnector
    extends LifecycleCloseable
    implements TcpConnector {
        private final AtomicBoolean closed;
        private final TcpConnector realConnector;
        final /* synthetic */ Xnio this$0;

        private <T extends Lifecycle & TcpConnector> LifecycleConnector(T lifecycle, AtomicBoolean closed) {
            this.this$0 = var1_1;
            super(lifecycle, closed);
            this.closed = closed;
            this.realConnector = lifecycle;
        }

        @Override
        public IoFuture<TcpChannel> connectTo(SocketAddress dest, IoHandler<? super TcpChannel> ioHandler) {
            if (this.closed.get()) {
                throw new IllegalStateException("Connector closed");
            }
            return this.realConnector.connectTo(dest, ioHandler);
        }

        @Override
        public IoFuture<TcpChannel> connectTo(SocketAddress src, SocketAddress dest, IoHandler<? super TcpChannel> ioHandler) {
            if (this.closed.get()) {
                throw new IllegalStateException("Connector closed");
            }
            return this.realConnector.connectTo(src, dest, ioHandler);
        }

        @Override
        public TcpClient createChannelSource(final SocketAddress dest) {
            return new TcpClient(){

                @Override
                public IoFuture<TcpChannel> open(IoHandler<? super TcpChannel> handler) {
                    return LifecycleConnector.this.realConnector.connectTo(dest, handler);
                }
            };
        }

        @Override
        public TcpClient createChannelSource(final SocketAddress src, final SocketAddress dest) {
            return new TcpClient(){

                @Override
                public IoFuture<TcpChannel> open(IoHandler<? super TcpChannel> handler) {
                    return LifecycleConnector.this.realConnector.connectTo(src, dest, handler);
                }
            };
        }
    }

    private class LifecycleCloseable
    implements Closeable {
        private final Lifecycle lifecycle;
        private final AtomicBoolean closed;

        private LifecycleCloseable(Lifecycle lifecycle, AtomicBoolean closed) {
            this.closed = closed;
            this.lifecycle = lifecycle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                Object object = Xnio.this.lifecycleLock;
                synchronized (object) {
                    this.lifecycle.stop();
                }
            }
        }
    }
}

