/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.io.IOException;
import java.lang.constant.Constable;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.core.nio.BioMulticastChannelImpl;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.spi.Lifecycle;
import org.jboss.xnio.spi.SpiUtils;
import org.jboss.xnio.spi.UdpServerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BioMulticastServer
implements Lifecycle,
UdpServerService {
    private static final Logger log = Logger.getLogger(BioMulticastServer.class);
    private IoHandlerFactory<? super UdpChannel> handlerFactory;
    private BioMulticastChannelImpl[] channels = new BioMulticastChannelImpl[0];
    private SocketAddress[] bindAddresses = new SocketAddress[0];
    private int receiveBufferSize = -1;
    private boolean reuseAddress = false;
    private int sendBufferSize = -1;
    private int trafficClass = -1;
    private boolean broadcast = false;
    private Executor executor;
    private ExecutorService executorService;
    protected static final Set<ChannelOption<?>> OPTIONS;

    public IoHandlerFactory<? super UdpChannel> getHandlerFactory() {
        return this.handlerFactory;
    }

    @Override
    public void setHandlerFactory(IoHandlerFactory<? super UdpChannel> handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public BioMulticastChannelImpl[] getChannels() {
        return this.channels;
    }

    public void setChannels(BioMulticastChannelImpl[] channels) {
        this.channels = channels;
    }

    public SocketAddress[] getBindAddresses() {
        return this.bindAddresses;
    }

    @Override
    public void setBindAddresses(SocketAddress[] bindAddresses) {
        this.bindAddresses = bindAddresses;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    @Override
    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Override
    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    @Override
    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    @Override
    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        if (this.executor == null) {
            this.executorService = Executors.newCachedThreadPool();
            this.executor = this.executorService;
        }
        if (this.handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        int bindCount = this.bindAddresses.length;
        MulticastSocket[] sockets = new MulticastSocket[bindCount];
        boolean ok = false;
        try {
            this.channels = new BioMulticastChannelImpl[bindCount];
            for (int i = 0; i < bindCount; ++i) {
                if (this.bindAddresses[i] == null) {
                    throw new NullPointerException("bindAddresses[i] is null");
                }
                MulticastSocket socket = new MulticastSocket(this.bindAddresses[i]);
                socket.setBroadcast(this.broadcast);
                if (this.receiveBufferSize != -1) {
                    socket.setReceiveBufferSize(this.receiveBufferSize);
                }
                socket.setReuseAddress(this.reuseAddress);
                if (this.sendBufferSize != -1) {
                    socket.setSendBufferSize(this.sendBufferSize);
                }
                if (this.trafficClass != -1) {
                    socket.setTrafficClass(this.trafficClass);
                }
                sockets[i] = socket;
                IoHandler<? super UdpChannel> handler = this.handlerFactory.createHandler();
                this.channels[i] = new BioMulticastChannelImpl(this.sendBufferSize, this.receiveBufferSize, this.executor, handler, socket);
                this.channels[i].open();
                if (SpiUtils.handleOpened(handler, this.channels[i])) continue;
                IoUtils.safeClose(socket);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (MulticastSocket socket : sockets) {
                    IoUtils.safeClose(socket);
                }
            }
        }
    }

    @Override
    public void stop() {
        if (this.executorService != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        BioMulticastServer.this.executorService.shutdown();
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                log.trace(t, "Shutting down executor service failed", new Object[0]);
            }
        }
        this.executorService = null;
        this.executor = null;
        if (this.channels != null) {
            for (BioMulticastChannelImpl channel : this.channels) {
                IoUtils.safeClose(channel);
            }
        }
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.RECEIVE_BUFFER).equals(option)) {
            int v = this.receiveBufferSize;
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        if (((Object)CommonOptions.REUSE_ADDRESSES).equals(option)) {
            return (T)Boolean.valueOf(this.reuseAddress);
        }
        if (((Object)CommonOptions.SEND_BUFFER).equals(option)) {
            int v = this.sendBufferSize;
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        if (((Object)CommonOptions.IP_TRAFFIC_CLASS).equals(option)) {
            int v = this.trafficClass;
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        if (((Object)CommonOptions.BROADCAST).equals(option)) {
            return (T)Boolean.valueOf(this.broadcast);
        }
        throw new IllegalStateException("Failed to get supported option: " + option);
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return OPTIONS;
    }

    @Override
    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.RECEIVE_BUFFER).equals(option)) {
            this.setReceiveBufferSize((Integer)value);
            return this;
        }
        if (((Object)CommonOptions.REUSE_ADDRESSES).equals(option)) {
            this.setReuseAddress((Boolean)value);
            return this;
        }
        if (((Object)CommonOptions.SEND_BUFFER).equals(option)) {
            this.setSendBufferSize((Integer)value);
            return this;
        }
        if (((Object)CommonOptions.IP_TRAFFIC_CLASS).equals(option)) {
            this.setTrafficClass((Integer)value);
            return this;
        }
        if (((Object)CommonOptions.BROADCAST).equals(option)) {
            this.setBroadcast((Boolean)value);
            return this;
        }
        throw new IllegalStateException("Failed to set supported option: " + option);
    }

    static {
        HashSet<ChannelOption<Constable>> options = new HashSet<ChannelOption<Constable>>();
        options.add(CommonOptions.RECEIVE_BUFFER);
        options.add(CommonOptions.REUSE_ADDRESSES);
        options.add(CommonOptions.SEND_BUFFER);
        options.add(CommonOptions.IP_TRAFFIC_CLASS);
        options.add(CommonOptions.BROADCAST);
        OPTIONS = Collections.unmodifiableSet(options);
    }
}

