/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Pipe;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.core.nio.NioHandle;
import org.jboss.xnio.core.nio.NioProvider;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.spi.SpiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioPipeSourceChannelImpl
implements StreamSourceChannel {
    private static final Logger log = Logger.getLogger(NioPipeSourceChannelImpl.class);
    private final Pipe.SourceChannel channel;
    private final NioHandle handle;
    private final NioProvider nioProvider;
    private final IoHandler<? super StreamSourceChannel> handler;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);

    public NioPipeSourceChannelImpl(Pipe.SourceChannel channel, IoHandler<? super StreamSourceChannel> handler, NioProvider nioProvider) throws IOException {
        this.channel = channel;
        this.handler = handler;
        this.nioProvider = nioProvider;
        this.handle = nioProvider.addReadHandler(channel, new Handler());
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.channel.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.channel.read(dsts, offset, length);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        finally {
            this.nioProvider.removeChannel(this);
            this.handle.cancelKey();
            if (!this.callFlag.getAndSet(true)) {
                SpiUtils.handleClosed(this.handler, this);
            }
        }
    }

    @Override
    public void suspendReads() {
        try {
            this.handle.getSelectionKey().interestOps(0).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void resumeReads() {
        try {
            this.handle.getSelectionKey().interestOps(1).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void shutdownReads() throws IOException {
        this.channel.close();
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    @Override
    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return Collections.emptySet();
    }

    private final class Handler
    implements Runnable {
        private Handler() {
        }

        public void run() {
            SpiUtils.handleReadable(NioPipeSourceChannelImpl.this.handler, NioPipeSourceChannelImpl.this);
        }
    }
}

