/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.core.nio.BioMulticastServer;
import org.jboss.xnio.core.nio.NioHandle;
import org.jboss.xnio.core.nio.NioOneWayPipeConnection;
import org.jboss.xnio.core.nio.NioPipeConnection;
import org.jboss.xnio.core.nio.NioSelectorRunnable;
import org.jboss.xnio.core.nio.NioTcpConnector;
import org.jboss.xnio.core.nio.NioTcpServer;
import org.jboss.xnio.core.nio.NioUdpServer;
import org.jboss.xnio.core.nio.SelectorTask;
import org.jboss.xnio.core.nio.SynchronousHolder;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.spi.Lifecycle;
import org.jboss.xnio.spi.OneWayPipeService;
import org.jboss.xnio.spi.PipeService;
import org.jboss.xnio.spi.Provider;
import org.jboss.xnio.spi.TcpConnectorService;
import org.jboss.xnio.spi.TcpServerService;
import org.jboss.xnio.spi.UdpServerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioProvider
implements Provider,
Lifecycle {
    private static final Logger log = Logger.getLogger(NioProvider.class);
    private Executor executor;
    private ExecutorService executorService;
    private ThreadFactory selectorThreadFactory;
    private final Set<NioSelectorRunnable> readers = new HashSet<NioSelectorRunnable>();
    private final Set<NioSelectorRunnable> writers = new HashSet<NioSelectorRunnable>();
    private final Set<NioSelectorRunnable> connectors = new HashSet<NioSelectorRunnable>();
    private int readSelectorThreads = 2;
    private int writeSelectorThreads = 1;
    private int connectionSelectorThreads = 1;
    private Set<Channel> managedChannelSet = Collections.synchronizedSet(new HashSet());

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public ThreadFactory getSelectorThreadFactory() {
        return this.selectorThreadFactory;
    }

    public void setSelectorThreadFactory(ThreadFactory selectorThreadFactory) {
        this.selectorThreadFactory = selectorThreadFactory;
    }

    public int getReadSelectorThreads() {
        return this.readSelectorThreads;
    }

    public void setReadSelectorThreads(int readSelectorThreads) {
        this.readSelectorThreads = readSelectorThreads;
    }

    public int getWriteSelectorThreads() {
        return this.writeSelectorThreads;
    }

    public void setWriteSelectorThreads(int writeSelectorThreads) {
        this.writeSelectorThreads = writeSelectorThreads;
    }

    public int getConnectionSelectorThreads() {
        return this.connectionSelectorThreads;
    }

    public void setConnectionSelectorThreads(int connectionSelectorThreads) {
        this.connectionSelectorThreads = connectionSelectorThreads;
    }

    @Override
    public void start() throws IOException {
        int i;
        if (this.selectorThreadFactory == null) {
            this.selectorThreadFactory = Executors.defaultThreadFactory();
        }
        if (this.executor == null) {
            this.executorService = Executors.newCachedThreadPool();
            this.executor = this.executorService;
        }
        for (i = 0; i < this.readSelectorThreads; ++i) {
            this.readers.add(new NioSelectorRunnable());
        }
        for (i = 0; i < this.writeSelectorThreads; ++i) {
            this.writers.add(new NioSelectorRunnable());
        }
        for (i = 0; i < this.connectionSelectorThreads; ++i) {
            this.connectors.add(new NioSelectorRunnable());
        }
        for (NioSelectorRunnable runnable : this.readers) {
            this.selectorThreadFactory.newThread(runnable).start();
        }
        for (NioSelectorRunnable runnable : this.writers) {
            this.selectorThreadFactory.newThread(runnable).start();
        }
        for (NioSelectorRunnable runnable : this.connectors) {
            this.selectorThreadFactory.newThread(runnable).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        ArrayList<Channel> channels;
        Set<Channel> set = this.managedChannelSet;
        synchronized (set) {
            channels = new ArrayList<Channel>(this.managedChannelSet);
            this.managedChannelSet.clear();
        }
        for (Channel channel : channels) {
            System.out.println("AUTO CLOSING " + channel);
            IoUtils.safeClose(channel);
        }
        for (NioSelectorRunnable runnable : this.readers) {
            runnable.shutdown();
        }
        for (NioSelectorRunnable runnable : this.writers) {
            runnable.shutdown();
        }
        for (NioSelectorRunnable runnable : this.connectors) {
            runnable.shutdown();
        }
        this.readers.clear();
        this.writers.clear();
        this.connectors.clear();
        if (this.executorService != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NioProvider.this.executorService.shutdown();
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                log.trace(t, "Failed to shut down executor service", new Object[0]);
            }
            finally {
                this.executorService = null;
            }
        }
    }

    @Override
    public TcpServerService createTcpServer() {
        NioTcpServer tcpServer = new NioTcpServer();
        tcpServer.setNioProvider(this);
        return tcpServer;
    }

    @Override
    public TcpConnectorService createTcpConnector() {
        NioTcpConnector tcpConnector = new NioTcpConnector();
        tcpConnector.setNioProvider(this);
        return tcpConnector;
    }

    @Override
    public UdpServerService createUdpServer() {
        NioUdpServer udpServer = new NioUdpServer();
        udpServer.setNioProvider(this);
        return udpServer;
    }

    @Override
    public UdpServerService createMulticastUdpServer() {
        BioMulticastServer bioMulticastServer = new BioMulticastServer();
        bioMulticastServer.setExecutor(this.executor);
        return bioMulticastServer;
    }

    @Override
    public PipeService createPipe() {
        NioPipeConnection pipeConnection = new NioPipeConnection();
        pipeConnection.setNioProvider(this);
        return pipeConnection;
    }

    @Override
    public OneWayPipeService createOneWayPipe() {
        NioOneWayPipeConnection pipeConnection = new NioOneWayPipeConnection();
        pipeConnection.setNioProvider(this);
        return pipeConnection;
    }

    private NioHandle doAdd(final SelectableChannel channel, Set<NioSelectorRunnable> runnableSet, final Runnable handler) throws IOException {
        final SynchronousHolder holder = new SynchronousHolder();
        NioSelectorRunnable nioSelectorRunnable = null;
        int bestLoad = Integer.MAX_VALUE;
        for (NioSelectorRunnable item : runnableSet) {
            int load = item.getKeyLoad();
            if (load >= bestLoad) continue;
            nioSelectorRunnable = item;
            bestLoad = load;
        }
        if (nioSelectorRunnable == null) {
            throw new IOException("No threads defined to handle this event type");
        }
        final NioSelectorRunnable actualSelectorRunnable = nioSelectorRunnable;
        nioSelectorRunnable.queueTask(new SelectorTask(){

            public void run(Selector selector) {
                try {
                    SelectionKey selectionKey = channel.register(selector, 0);
                    NioHandle handle = new NioHandle(selectionKey, actualSelectorRunnable, handler, NioProvider.this.executor);
                    selectionKey.attach(handle);
                    holder.set(handle);
                }
                catch (ClosedChannelException e) {
                    holder.setProblem(e);
                }
            }
        });
        nioSelectorRunnable.wakeup();
        return (NioHandle)holder.get();
    }

    public NioHandle addConnectHandler(SelectableChannel channel, Runnable handler) throws IOException {
        return this.doAdd(channel, this.connectors, handler);
    }

    public NioHandle addReadHandler(SelectableChannel channel, Runnable handler) throws IOException {
        return this.doAdd(channel, this.readers, handler);
    }

    public NioHandle addWriteHandler(SelectableChannel channel, Runnable handler) throws IOException {
        return this.doAdd(channel, this.writers, handler);
    }

    public void addChannel(Channel channel) {
        this.managedChannelSet.add(channel);
    }

    public void removeChannel(Channel channel) {
        this.managedChannelSet.remove(channel);
    }
}

