/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.io.IOException;
import java.nio.channels.Pipe;
import java.util.concurrent.Executor;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.core.nio.NioPipeSinkChannelImpl;
import org.jboss.xnio.core.nio.NioPipeSourceChannelImpl;
import org.jboss.xnio.core.nio.NioProvider;
import org.jboss.xnio.spi.Lifecycle;
import org.jboss.xnio.spi.OneWayPipeService;
import org.jboss.xnio.spi.PipeEnd;
import org.jboss.xnio.spi.SpiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioOneWayPipeConnection
implements Lifecycle,
OneWayPipeService {
    private NioProvider nioProvider;
    private IoHandler<? super StreamSourceChannel> sourceHandler;
    private IoHandler<? super StreamSinkChannel> sinkHandler;
    private NioPipeSourceChannelImpl sourceSide;
    private NioPipeSinkChannelImpl sinkSide;
    private Executor executor;
    private Executor sourceSideExecutor;
    private Executor sinkSideExecutor;
    private final PipeEnd<StreamSourceChannel> sourceEnd = new PipeEnd<StreamSourceChannel>(){

        @Override
        public void setHandler(IoHandler<? super StreamSourceChannel> ioHandler) {
            NioOneWayPipeConnection.this.sourceHandler = ioHandler;
        }

        @Override
        public void setExecutor(Executor executor) {
            NioOneWayPipeConnection.this.sourceSideExecutor = executor;
        }
    };
    private final PipeEnd<StreamSinkChannel> sinkEnd = new PipeEnd<StreamSinkChannel>(){

        @Override
        public void setHandler(IoHandler<? super StreamSinkChannel> ioHandler) {
            NioOneWayPipeConnection.this.sinkHandler = ioHandler;
        }

        @Override
        public void setExecutor(Executor executor) {
            NioOneWayPipeConnection.this.sinkSideExecutor = executor;
        }
    };

    public NioProvider getNioCore() {
        return this.nioProvider;
    }

    public void setNioProvider(NioProvider nioProvider) {
        this.nioProvider = nioProvider;
    }

    public NioPipeSourceChannelImpl getSourceSide() {
        return this.sourceSide;
    }

    public void setSourceSide(NioPipeSourceChannelImpl sourceSide) {
        this.sourceSide = sourceSide;
    }

    public NioPipeSinkChannelImpl getSinkSide() {
        return this.sinkSide;
    }

    public void setSinkSide(NioPipeSinkChannelImpl sinkSide) {
        this.sinkSide = sinkSide;
    }

    public IoHandler<? super StreamSourceChannel> getSourceHandler() {
        return this.sourceHandler;
    }

    public void setSourceHandler(IoHandler<? super StreamSourceChannel> sourceHandler) {
        this.sourceHandler = sourceHandler;
    }

    public IoHandler<? super StreamSinkChannel> getSinkHandler() {
        return this.sinkHandler;
    }

    public void setSinkHandler(IoHandler<? super StreamSinkChannel> sinkHandler) {
        this.sinkHandler = sinkHandler;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public PipeEnd<StreamSourceChannel> getSourceEnd() {
        return this.sourceEnd;
    }

    @Override
    public PipeEnd<StreamSinkChannel> getSinkEnd() {
        return this.sinkEnd;
    }

    @Override
    public void start() throws IOException {
        if (this.sourceHandler == null) {
            throw new NullPointerException("leftHandler is null");
        }
        if (this.sinkHandler == null) {
            throw new NullPointerException("rightHandler is null");
        }
        if (this.nioProvider == null) {
            throw new NullPointerException("nioCore is null");
        }
        if (this.executor == null) {
            this.executor = this.nioProvider.getExecutor();
        }
        if (this.sourceSideExecutor == null) {
            this.sourceSideExecutor = this.executor;
        }
        if (this.sinkSideExecutor == null) {
            this.sinkSideExecutor = this.executor;
        }
        Pipe pipe = Pipe.open();
        Pipe.SourceChannel source = pipe.source();
        Pipe.SinkChannel sink = pipe.sink();
        source.configureBlocking(false);
        sink.configureBlocking(false);
        final NioPipeSourceChannelImpl sourceSide = new NioPipeSourceChannelImpl(source, this.sourceHandler, this.nioProvider);
        final NioPipeSinkChannelImpl sinkSide = new NioPipeSinkChannelImpl(sink, this.sinkHandler, this.nioProvider);
        this.sourceSide = sourceSide;
        this.sinkSide = sinkSide;
        this.sourceSideExecutor.execute(new Runnable(){

            public void run() {
                SpiUtils.handleOpened(NioOneWayPipeConnection.this.sourceHandler, sourceSide);
            }
        });
        this.sinkSideExecutor.execute(new Runnable(){

            public void run() {
                SpiUtils.handleOpened(NioOneWayPipeConnection.this.sinkHandler, sinkSide);
            }
        });
        this.nioProvider.addChannel(sourceSide);
        this.nioProvider.addChannel(sinkSide);
    }

    @Override
    public void stop() throws IOException {
        this.nioProvider.removeChannel(this.sourceSide);
        this.nioProvider.removeChannel(this.sinkSide);
        IoUtils.safeClose(this.sourceSide);
        IoUtils.safeClose(this.sinkSide);
        this.sourceSide = null;
        this.sinkSide = null;
    }
}

