/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.core.nio.NioHandle;
import org.jboss.xnio.core.nio.NioProvider;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.spi.SpiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioSocketChannelImpl
implements TcpChannel {
    private static final Logger log = Logger.getLogger(NioSocketChannelImpl.class);
    private final SocketChannel socketChannel;
    private final Socket socket;
    private final IoHandler<? super TcpChannel> handler;
    private final NioHandle readHandle;
    private final NioHandle writeHandle;
    private final NioProvider nioProvider;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private static final Set<ChannelOption<?>> OPTIONS = Collections.singleton(CommonOptions.CLOSE_ABORT);

    public NioSocketChannelImpl(NioProvider nioProvider, SocketChannel socketChannel, IoHandler<? super TcpChannel> handler) throws IOException {
        this.handler = handler;
        this.socketChannel = socketChannel;
        this.nioProvider = nioProvider;
        this.socket = socketChannel.socket();
        this.readHandle = nioProvider.addReadHandler(socketChannel, new ReadHandler());
        this.writeHandle = nioProvider.addWriteHandler(socketChannel, new WriteHandler());
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.socketChannel.write(srcs, offset, length);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.socketChannel.write(srcs);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.socketChannel.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        try {
            this.socketChannel.close();
            this.nioProvider.removeChannel(this);
            this.readHandle.cancelKey();
            this.writeHandle.cancelKey();
            if (this.callFlag.getAndSet(true)) return;
        }
        catch (Throwable throwable) {
            this.nioProvider.removeChannel(this);
            this.readHandle.cancelKey();
            this.writeHandle.cancelKey();
            if (this.callFlag.getAndSet(true)) throw throwable;
            log.trace("Closing channel %s", this);
            SpiUtils.handleClosed(this.handler, this);
            throw throwable;
        }
        log.trace("Closing channel %s", this);
        SpiUtils.handleClosed(this.handler, this);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.socketChannel.read(dsts, offset, length);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.socketChannel.read(dsts);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.socketChannel.read(dst);
    }

    @Override
    public void suspendReads() {
        try {
            this.readHandle.getSelectionKey().interestOps(0).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void suspendWrites() {
        try {
            this.writeHandle.getSelectionKey().interestOps(0).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void resumeReads() {
        try {
            this.readHandle.getSelectionKey().interestOps(1).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void resumeWrites() {
        try {
            this.writeHandle.getSelectionKey().interestOps(4).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void shutdownReads() throws IOException {
        this.socket.shutdownInput();
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.socket.shutdownOutput();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        if (option == null) {
            throw new NullPointerException("name is null");
        }
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.CLOSE_ABORT).equals(option)) {
            return (T)Boolean.valueOf(this.socket.getSoLinger() != -1);
        }
        throw new UnsupportedOptionException("Option " + option + " not supported");
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return OPTIONS;
    }

    @Override
    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == null) {
            throw new NullPointerException("name is null");
        }
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.CLOSE_ABORT).equals(option)) {
            if (value == null) {
                throw new NullPointerException("value is null");
            }
            this.socket.setSoLinger((Boolean)value, 0);
        }
        return this;
    }

    private final class WriteHandler
    implements Runnable {
        private WriteHandler() {
        }

        public void run() {
            SpiUtils.handleWritable(NioSocketChannelImpl.this.handler, NioSocketChannelImpl.this);
        }
    }

    private final class ReadHandler
    implements Runnable {
        private ReadHandler() {
        }

        public void run() {
            SpiUtils.handleReadable(NioSocketChannelImpl.this.handler, NioSocketChannelImpl.this);
        }
    }
}

