/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.core.nio.NioHandle;
import org.jboss.xnio.core.nio.NioProvider;
import org.jboss.xnio.core.nio.NioSocketChannelImpl;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.spi.Lifecycle;
import org.jboss.xnio.spi.SpiUtils;
import org.jboss.xnio.spi.TcpServerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioTcpServer
implements Lifecycle,
TcpServerService {
    private static final Logger log = Logger.getLogger(NioTcpServer.class);
    private NioHandle[] handles;
    private ServerSocket[] serverSockets;
    private ServerSocketChannel[] serverSocketChannels;
    private Executor executor;
    private IoHandlerFactory<? super TcpChannel> handlerFactory;
    private boolean reuseAddress = true;
    private int receiveBufferSize = -1;
    private int backlog = -1;
    private boolean keepAlive = false;
    private boolean oobInline = false;
    private boolean tcpNoDelay = false;
    private NioProvider nioProvider;
    private SocketAddress[] bindAddresses = new SocketAddress[0];
    private static final Set<ChannelOption<?>> OPTIONS;

    public NioProvider getNioProvider() {
        return this.nioProvider;
    }

    public void setNioProvider(NioProvider nioProvider) {
        this.nioProvider = nioProvider;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    @Override
    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getBacklog() {
        return this.backlog;
    }

    @Override
    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public IoHandlerFactory<? super TcpChannel> getHandlerFactory() {
        return this.handlerFactory;
    }

    @Override
    public void setHandlerFactory(IoHandlerFactory<? super TcpChannel> handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public SocketAddress[] getBindAddresses() {
        return this.bindAddresses;
    }

    @Override
    public void setBindAddresses(SocketAddress[] bindAddresses) {
        this.bindAddresses = bindAddresses;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isOobInline() {
        return this.oobInline;
    }

    @Override
    public void setOobInline(boolean oobInline) {
        this.oobInline = oobInline;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Override
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void start() throws IOException {
        int i;
        if (this.nioProvider == null) {
            throw new NullPointerException("nioProvider is null");
        }
        if (this.handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        int bindCount = this.bindAddresses.length;
        this.serverSocketChannels = new ServerSocketChannel[bindCount];
        this.serverSockets = new ServerSocket[bindCount];
        this.handles = new NioHandle[bindCount];
        for (i = 0; i < bindCount; ++i) {
            try {
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.configureBlocking(false);
                ServerSocket serverSocket = serverSocketChannel.socket();
                serverSocket.setReuseAddress(this.reuseAddress);
                if (this.receiveBufferSize > 0) {
                    serverSocket.setReceiveBufferSize(this.receiveBufferSize);
                }
                NioHandle handle = this.nioProvider.addConnectHandler(serverSocketChannel, new Handler(i));
                SocketAddress bindAddress = this.bindAddresses[i];
                if (this.backlog > 0) {
                    log.trace("Binding TCP server to %s with a backlog of %d", bindAddress, this.backlog);
                    serverSocket.bind(bindAddress, this.backlog);
                } else {
                    log.trace("Binding TCP server to %s", bindAddress);
                    serverSocket.bind(bindAddress);
                }
                this.serverSocketChannels[i] = serverSocketChannel;
                this.serverSockets[i] = serverSocket;
                this.handles[i] = handle;
                continue;
            }
            catch (IOException ex) {
                while (i >= 0) {
                    IoUtils.safeClose(this.serverSocketChannels[i]);
                    --i;
                }
                throw ex;
            }
        }
        for (i = 0; i < bindCount; ++i) {
            this.handles[i].getSelectionKey().interestOps(16).selector().wakeup();
        }
        log.trace("Successfully started TCP server");
    }

    @Override
    public void stop() {
        int bindCount = this.bindAddresses.length;
        for (int i = 0; i < bindCount; ++i) {
            if (this.handles != null && this.handles.length > i && this.handles[i] != null && this.handles[i] != null) {
                try {
                    this.handles[i].cancelKey();
                }
                catch (Throwable t) {
                    log.trace(t, "Cancel key failed", new Object[0]);
                }
            }
            if (this.serverSocketChannels == null || this.serverSocketChannels.length <= i || this.serverSocketChannels[i] == null || this.serverSocketChannels[i] == null) continue;
            try {
                this.serverSocketChannels[i].close();
                continue;
            }
            catch (Throwable t) {
                log.trace(t, "Cancel key failed", new Object[0]);
            }
        }
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        if (option == null) {
            throw new NullPointerException("name is null");
        }
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.BACKLOG).equals(option)) {
            int v = this.backlog;
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        if (((Object)CommonOptions.KEEP_ALIVE).equals(option)) {
            return (T)Boolean.valueOf(this.keepAlive);
        }
        if (((Object)CommonOptions.TCP_OOB_INLINE).equals(option)) {
            return (T)Boolean.valueOf(this.oobInline);
        }
        if (((Object)CommonOptions.RECEIVE_BUFFER).equals(option)) {
            int v = this.receiveBufferSize;
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        if (((Object)CommonOptions.REUSE_ADDRESSES).equals(option)) {
            return (T)Boolean.valueOf(this.reuseAddress);
        }
        if (((Object)CommonOptions.TCP_NODELAY).equals(option)) {
            return (T)Boolean.valueOf(this.tcpNoDelay);
        }
        throw new IllegalStateException("Failed to get supported option: " + option);
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return OPTIONS;
    }

    @Override
    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == null) {
            throw new NullPointerException("name is null");
        }
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.BACKLOG).equals(option)) {
            this.setBacklog((Integer)value);
            return this;
        }
        if (((Object)CommonOptions.KEEP_ALIVE).equals(option)) {
            this.setKeepAlive((Boolean)value);
            return this;
        }
        if (((Object)CommonOptions.TCP_OOB_INLINE).equals(option)) {
            this.setOobInline((Boolean)value);
            return this;
        }
        if (((Object)CommonOptions.RECEIVE_BUFFER).equals(option)) {
            this.setReceiveBufferSize((Integer)value);
            return this;
        }
        if (((Object)CommonOptions.REUSE_ADDRESSES).equals(option)) {
            this.setReuseAddress((Boolean)value);
            return this;
        }
        if (((Object)CommonOptions.TCP_NODELAY).equals(option)) {
            this.setTcpNoDelay((Boolean)value);
            return this;
        }
        throw new IllegalStateException("Failed to set supported option: " + option);
    }

    static {
        HashSet<ChannelOption<Comparable<Boolean>>> options = new HashSet<ChannelOption<Comparable<Boolean>>>();
        options.add(CommonOptions.REUSE_ADDRESSES);
        options.add(CommonOptions.RECEIVE_BUFFER);
        options.add(CommonOptions.BACKLOG);
        options.add(CommonOptions.KEEP_ALIVE);
        options.add(CommonOptions.TCP_OOB_INLINE);
        options.add(CommonOptions.TCP_NODELAY);
        OPTIONS = Collections.unmodifiableSet(options);
    }

    private final class Handler
    implements Runnable {
        private final int idx;

        public Handler(int idx) {
            this.idx = idx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: {
                try {
                    SocketChannel socketChannel = NioTcpServer.this.serverSocketChannels[this.idx].accept();
                    if (socketChannel == null) break block8;
                    boolean ok = false;
                    try {
                        socketChannel.configureBlocking(false);
                        Socket socket = socketChannel.socket();
                        socket.setKeepAlive(NioTcpServer.this.keepAlive);
                        socket.setOOBInline(NioTcpServer.this.oobInline);
                        socket.setTcpNoDelay(NioTcpServer.this.tcpNoDelay);
                        IoHandler streamIoHandler = NioTcpServer.this.handlerFactory.createHandler();
                        NioSocketChannelImpl channel = new NioSocketChannelImpl(NioTcpServer.this.nioProvider, socketChannel, streamIoHandler);
                        ok = SpiUtils.handleOpened(streamIoHandler, channel);
                        if (ok) {
                            NioTcpServer.this.nioProvider.addChannel(channel);
                            log.trace("TCP server accepted connection");
                        }
                    }
                    finally {
                        if (!ok) {
                            log.trace("TCP server failed to accept connection");
                            IoUtils.safeClose(socketChannel);
                        }
                    }
                }
                catch (ClosedChannelException e) {
                    log.trace("Channel closed: %s", e.getMessage());
                    return;
                }
                catch (IOException e) {
                    log.trace(e, "I/O error on TCP server", new Object[0]);
                }
            }
        }
    }
}

