/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Buffers {
    private Buffers() {
    }

    public static <T extends Buffer> T flip(T buffer) {
        buffer.flip();
        return buffer;
    }

    public static <T extends Buffer> T clear(T buffer) {
        buffer.clear();
        return buffer;
    }

    public static <T extends Buffer> T limit(T buffer, int limit) {
        buffer.limit(limit);
        return buffer;
    }

    public static <T extends Buffer> T mark(T buffer) {
        buffer.mark();
        return buffer;
    }

    public static <T extends Buffer> T position(T buffer, int position) {
        buffer.position(position);
        return buffer;
    }

    public static <T extends Buffer> T reset(T buffer) {
        buffer.reset();
        return buffer;
    }

    public static <T extends Buffer> T rewind(T buffer) {
        buffer.rewind();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer slice(ByteBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                ByteBuffer byteBuffer = buffer.slice();
                return byteBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            ByteBuffer byteBuffer = buffer.slice();
            return byteBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static ByteBuffer fill(ByteBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (byte)value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put((byte)value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharBuffer slice(CharBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                CharBuffer charBuffer = buffer.slice();
                return charBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            CharBuffer charBuffer = buffer.slice();
            return charBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static CharBuffer fill(CharBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (char)value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put((char)value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShortBuffer slice(ShortBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                ShortBuffer shortBuffer = buffer.slice();
                return shortBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            ShortBuffer shortBuffer = buffer.slice();
            return shortBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static ShortBuffer fill(ShortBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (short)value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put((short)value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntBuffer slice(IntBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                IntBuffer intBuffer = buffer.slice();
                return intBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            IntBuffer intBuffer = buffer.slice();
            return intBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static IntBuffer fill(IntBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put(value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LongBuffer slice(LongBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                LongBuffer longBuffer = buffer.slice();
                return longBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            LongBuffer longBuffer = buffer.slice();
            return longBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static LongBuffer fill(LongBuffer buffer, long value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put(value);
            }
        }
        return buffer;
    }

    public static <T extends Buffer> T skip(T buffer, int cnt) {
        if (cnt > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        buffer.position(buffer.position() + cnt);
        return buffer;
    }
}

