/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.MultipointDatagramChannel;
import org.jboss.xnio.channels.MultipointReadResult;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.spi.SpiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioDatagramChannelImpl
implements UdpChannel {
    private static final Logger log = Logger.getLogger(BioDatagramChannelImpl.class);
    private final DatagramSocket datagramSocket;
    private final DatagramPacket receivePacket;
    private final ByteBuffer receiveBuffer;
    private final DatagramPacket sendPacket;
    private final ByteBuffer sendBuffer;
    private final Executor handlerExecutor;
    private final IoHandler<? super MultipointDatagramChannel<SocketAddress>> handler;
    private final Runnable readHandlerTask = new ReadHandlerTask();
    private final Runnable writeHandlerTask = new WriteHandlerTask();
    private final ReaderTask readerTask = new ReaderTask();
    private final WriterTask writerTask = new WriterTask();
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private boolean enableRead;
    private boolean enableWrite;
    private boolean readable;
    private boolean writable;
    private IOException readException;
    private final AtomicBoolean closeCalled = new AtomicBoolean(false);
    protected static final Set<ChannelOption<?>> OPTIONS;

    protected BioDatagramChannelImpl(int sendBufSize, int recvBufSize, Executor handlerExecutor, IoHandler<? super MultipointDatagramChannel<SocketAddress>> handler, DatagramSocket datagramSocket) {
        this.datagramSocket = datagramSocket;
        this.handlerExecutor = handlerExecutor;
        this.handler = handler;
        if (sendBufSize == -1) {
            sendBufSize = 4096;
        } else if (sendBufSize < 0) {
            throw new IllegalArgumentException("sendBufSize is less than 0");
        }
        if (recvBufSize == -1) {
            recvBufSize = 4096;
        } else if (recvBufSize < 0) {
            throw new IllegalArgumentException("recvBufSize is less than 0");
        }
        byte[] sendBufferBytes = new byte[sendBufSize];
        this.sendBuffer = ByteBuffer.wrap(sendBufferBytes);
        byte[] recvBufferBytes = new byte[recvBufSize];
        this.receiveBuffer = ByteBuffer.wrap(recvBufferBytes);
        this.sendPacket = new DatagramPacket(sendBufferBytes, sendBufSize);
        this.receivePacket = new DatagramPacket(recvBufferBytes, recvBufSize);
        log.trace("Constructed a new channel (%s); send buffer size %d, receive buffer size %d", this, sendBufSize, recvBufSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() {
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        Thread readThread = threadFactory.newThread(this.readerTask);
        boolean ok = false;
        try {
            Thread writeThread = threadFactory.newThread(this.writerTask);
            try {
                readThread.start();
                writeThread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    this.writerTask.cancel();
                }
            }
        }
        finally {
            if (!ok) {
                this.readerTask.cancel();
            }
        }
        log.trace("Channel %s opened", this);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.datagramSocket.getLocalSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultipointReadResult<SocketAddress> receive(ByteBuffer buffer) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (!this.readable) {
                return null;
            }
            this.readable = false;
            if (this.readException != null) {
                try {
                    this.readException.setStackTrace(new Throwable().getStackTrace());
                    throw this.readException;
                }
                catch (Throwable throwable) {
                    this.readException = null;
                    throw throwable;
                }
            }
            int size = Math.min(buffer.remaining(), this.receiveBuffer.remaining());
            this.receiveBuffer.limit(size);
            buffer.put(this.receiveBuffer);
            this.readLock.notify();
            final SocketAddress socketAddress = this.receivePacket.getSocketAddress();
            return new MultipointReadResult<SocketAddress>(){

                @Override
                public SocketAddress getSourceAddress() {
                    return socketAddress;
                }

                @Override
                public SocketAddress getDestinationAddress() {
                    return null;
                }
            };
        }
    }

    @Override
    public boolean isOpen() {
        return !this.datagramSocket.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.enableWrite = false;
        }
        object = this.readLock;
        synchronized (object) {
            this.enableRead = false;
        }
        try {
            this.readerTask.cancel();
        }
        catch (Throwable t) {
            log.trace(t, "Reader task cancel failed", new Object[0]);
        }
        try {
            this.writerTask.cancel();
        }
        catch (Throwable t) {
            log.trace(t, "Writer task cancel failed", new Object[0]);
        }
        object = this.writeLock;
        synchronized (object) {
            this.writable = false;
        }
        object = this.readLock;
        synchronized (object) {
            this.readable = false;
        }
        this.datagramSocket.close();
        if (!this.closeCalled.getAndSet(true)) {
            SpiUtils.handleClosed(this.handler, this);
            log.trace("Closing channel %s", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(SocketAddress target, ByteBuffer buffer) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (!this.writable) {
                return false;
            }
            this.sendBuffer.clear();
            if (this.sendBuffer.remaining() < buffer.remaining()) {
                throw new IOException("Insufficient room in send buffer (send will never succeed); send buffer is " + this.sendBuffer.remaining() + " bytes, but transmitted datagram is " + buffer.remaining() + " bytes");
            }
            this.sendBuffer.put(buffer);
            this.sendPacket.setSocketAddress(target);
            this.sendPacket.setData(this.sendBuffer.array(), this.sendBuffer.arrayOffset(), this.sendBuffer.position());
            this.writeLock.notifyAll();
            this.writable = false;
            return true;
        }
    }

    @Override
    public boolean send(SocketAddress target, ByteBuffer[] dsts) throws IOException {
        return this.send(target, dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(SocketAddress target, ByteBuffer[] dsts, int offset, int length) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            int i;
            if (!this.writable) {
                return false;
            }
            this.sendBuffer.clear();
            long t = 0L;
            for (i = 0; i < length; ++i) {
                t += (long)dsts[i + offset].remaining();
            }
            if ((long)this.sendBuffer.remaining() < t) {
                throw new IOException("Insufficient room in send buffer (send will never succeed); send buffer is " + this.sendBuffer.remaining() + " bytes, but transmitted datagram is " + t + " bytes");
            }
            for (i = 0; i < length; ++i) {
                this.sendBuffer.put(dsts[i + offset]);
            }
            this.sendPacket.setSocketAddress(target);
            this.sendPacket.setData(this.sendBuffer.array(), this.sendBuffer.arrayOffset(), this.sendBuffer.position());
            this.writeLock.notifyAll();
            this.writable = false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendReads() {
        Object object = this.readLock;
        synchronized (object) {
            this.enableRead = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendWrites() {
        Object object = this.readLock;
        synchronized (object) {
            this.enableWrite = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeReads() {
        Object object = this.readLock;
        synchronized (object) {
            this.enableRead = true;
            if (this.readable) {
                this.handlerExecutor.execute(this.readHandlerTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeWrites() {
        Object object = this.writeLock;
        synchronized (object) {
            this.enableWrite = true;
            if (this.writable) {
                this.handlerExecutor.execute(this.writeHandlerTask);
            }
        }
    }

    @Override
    public void shutdownReads() throws IOException {
        throw new UnsupportedOperationException("Shutdown reads");
    }

    @Override
    public void shutdownWrites() throws IOException {
        throw new UnsupportedOperationException("Shutdown writes");
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.BROADCAST).equals(option)) {
            return (T)Boolean.valueOf(this.datagramSocket.getBroadcast());
        }
        if (((Object)CommonOptions.IP_TRAFFIC_CLASS).equals(option)) {
            int v = this.datagramSocket.getTrafficClass();
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        throw new IllegalStateException("Failed to get supported option: " + option);
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return OPTIONS;
    }

    @Override
    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.BROADCAST).equals(option)) {
            this.datagramSocket.setBroadcast((Boolean)value);
            return this;
        }
        if (((Object)CommonOptions.IP_TRAFFIC_CLASS).equals(option)) {
            this.datagramSocket.setTrafficClass((Integer)value);
            return this;
        }
        throw new IllegalStateException("Failed to set supported option: " + option);
    }

    @Override
    public UdpChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        throw new UnsupportedOptionException("Multicast not supported");
    }

    @Override
    public UdpChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source) throws IOException {
        throw new UnsupportedOptionException("Multicast not supported");
    }

    static {
        HashSet<ChannelOption<Comparable<Boolean>>> options = new HashSet<ChannelOption<Comparable<Boolean>>>();
        options.add(CommonOptions.BROADCAST);
        options.add(CommonOptions.IP_TRAFFIC_CLASS);
        OPTIONS = Collections.unmodifiableSet(options);
    }

    private final class WriteHandlerTask
    implements Runnable {
        private WriteHandlerTask() {
        }

        public void run() {
            SpiUtils.handleWritable(BioDatagramChannelImpl.this.handler, BioDatagramChannelImpl.this);
        }
    }

    private final class ReadHandlerTask
    implements Runnable {
        private ReadHandlerTask() {
        }

        public void run() {
            SpiUtils.handleReadable(BioDatagramChannelImpl.this.handler, BioDatagramChannelImpl.this);
        }
    }

    private final class WriterTask
    implements Runnable {
        private volatile Thread thread;

        private WriterTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.thread = Thread.currentThread();
            try {
                while (true) {
                    Object object = BioDatagramChannelImpl.this.writeLock;
                    synchronized (object) {
                        BioDatagramChannelImpl.this.writable = true;
                        if (BioDatagramChannelImpl.this.enableWrite) {
                            BioDatagramChannelImpl.this.enableWrite = false;
                            BioDatagramChannelImpl.this.handlerExecutor.execute(BioDatagramChannelImpl.this.writeHandlerTask);
                        }
                        while (BioDatagramChannelImpl.this.writable) {
                            try {
                                BioDatagramChannelImpl.this.writeLock.wait();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                    }
                    try {
                        BioDatagramChannelImpl.this.datagramSocket.send(BioDatagramChannelImpl.this.sendPacket);
                    }
                    catch (IOException e) {
                        log.trace("Packet send failed: %s", e);
                    }
                }
            }
            finally {
                this.thread = null;
            }
        }

        public void cancel() {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }
    }

    private final class ReaderTask
    implements Runnable {
        private volatile Thread thread;

        private ReaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.thread = Thread.currentThread();
            try {
                while (true) {
                    Object object = BioDatagramChannelImpl.this.readLock;
                    synchronized (object) {
                        while (BioDatagramChannelImpl.this.readable) {
                            try {
                                BioDatagramChannelImpl.this.readLock.wait();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                    }
                    try {
                        BioDatagramChannelImpl.this.datagramSocket.receive(BioDatagramChannelImpl.this.receivePacket);
                    }
                    catch (IOException e) {
                        Object object2 = BioDatagramChannelImpl.this.readLock;
                        synchronized (object2) {
                            BioDatagramChannelImpl.this.readException = e;
                            BioDatagramChannelImpl.this.readable = true;
                            if (BioDatagramChannelImpl.this.enableRead) {
                                BioDatagramChannelImpl.this.handlerExecutor.execute(BioDatagramChannelImpl.this.readHandlerTask);
                            }
                            continue;
                        }
                    }
                    object = BioDatagramChannelImpl.this.readLock;
                    synchronized (object) {
                        BioDatagramChannelImpl.this.receiveBuffer.limit(BioDatagramChannelImpl.this.receivePacket.getLength());
                        BioDatagramChannelImpl.this.receiveBuffer.position(0);
                        BioDatagramChannelImpl.this.readable = true;
                        if (BioDatagramChannelImpl.this.enableRead) {
                            BioDatagramChannelImpl.this.handlerExecutor.execute(BioDatagramChannelImpl.this.readHandlerTask);
                        }
                    }
                }
            }
            finally {
                this.thread = null;
            }
        }

        public void cancel() {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }
    }
}

