/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Executor;
import org.jboss.xnio.core.nio.NioSelectorRunnable;
import org.jboss.xnio.core.nio.SelectorTask;

public final class NioHandle {
    private final SelectionKey selectionKey;
    private final NioSelectorRunnable selectorRunnable;
    private final Runnable handler;
    private final Executor handlerExecutor;

    NioHandle(SelectionKey selectionKey, NioSelectorRunnable selectorRunnable, Runnable handler, Executor handlerExecutor) {
        this.selectionKey = selectionKey;
        this.selectorRunnable = selectorRunnable;
        this.handler = handler;
        this.handlerExecutor = handlerExecutor;
    }

    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    NioSelectorRunnable getSelectorRunnable() {
        return this.selectorRunnable;
    }

    Runnable getHandler() {
        return this.handler;
    }

    Executor getHandlerExecutor() {
        return this.handlerExecutor;
    }

    public void cancelKey() {
        this.selectorRunnable.queueTask(new SelectorTask(){

            public void run(Selector selector) {
                NioHandle.this.selectionKey.cancel();
            }
        });
        this.selectionKey.selector().wakeup();
    }
}

