/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.core.nio;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.xnio.AbstractIoFuture;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.FinishedIoFuture;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.TcpClient;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.core.nio.NioHandle;
import org.jboss.xnio.core.nio.NioProvider;
import org.jboss.xnio.core.nio.NioSocketChannelImpl;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.spi.Lifecycle;
import org.jboss.xnio.spi.SpiUtils;
import org.jboss.xnio.spi.TcpConnectorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioTcpConnector
implements Lifecycle,
TcpConnector,
TcpConnectorService {
    private static final Logger log = Logger.getLogger(NioTcpConnector.class);
    private NioProvider nioProvider;
    private Executor executor;
    private boolean keepAlive = false;
    private boolean oobInline = false;
    private int receiveBufferSize = -1;
    private boolean reuseAddress = false;
    private int sendBufferSize = -1;
    private boolean tcpNoDelay = false;
    private int connectTimeout = -1;
    private static final Set<ChannelOption<?>> OPTIONS;

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isOobInline() {
        return this.oobInline;
    }

    @Override
    public void setOobInline(boolean oobInline) {
        this.oobInline = oobInline;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    @Override
    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Override
    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Override
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public NioProvider getNioProvider() {
        return this.nioProvider;
    }

    public void setNioProvider(NioProvider nioProvider) {
        this.nioProvider = nioProvider;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void start() {
        if (this.nioProvider == null) {
            throw new NullPointerException("nioProvider is null");
        }
        if (this.executor == null) {
            this.executor = this.nioProvider.getExecutor();
        }
    }

    @Override
    public void stop() {
        this.executor = null;
    }

    private void configureStream(Socket socket) throws SocketException {
        socket.setKeepAlive(this.keepAlive);
        socket.setOOBInline(this.oobInline);
        if (this.receiveBufferSize > 0) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        socket.setReuseAddress(this.reuseAddress);
        if (this.sendBufferSize > 0) {
            socket.setSendBufferSize(this.sendBufferSize);
        }
        socket.setTcpNoDelay(this.tcpNoDelay);
    }

    @Override
    public IoFuture<TcpChannel> connectTo(SocketAddress dest, IoHandler<? super TcpChannel> handler) {
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        return this.doConnectTo(null, dest, handler);
    }

    @Override
    public IoFuture<TcpChannel> connectTo(SocketAddress src, SocketAddress dest, IoHandler<? super TcpChannel> handler) {
        if (src == null) {
            throw new NullPointerException("src is null");
        }
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        return this.doConnectTo(src, dest, handler);
    }

    @Override
    public TcpClient createChannelSource(final SocketAddress dest) {
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        return new TcpClient(){

            @Override
            public IoFuture<TcpChannel> open(IoHandler<? super TcpChannel> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is null");
                }
                return NioTcpConnector.this.doConnectTo(null, dest, handler);
            }
        };
    }

    @Override
    public TcpClient createChannelSource(final SocketAddress src, final SocketAddress dest) {
        if (src == null) {
            throw new NullPointerException("src is null");
        }
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        return new TcpClient(){

            @Override
            public IoFuture<TcpChannel> open(IoHandler<? super TcpChannel> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is null");
                }
                return NioTcpConnector.this.doConnectTo(src, dest, handler);
            }
        };
    }

    private IoFuture<TcpChannel> doConnectTo(final SocketAddress src, final SocketAddress dest, final IoHandler<? super TcpChannel> handler) {
        try {
            log.trace("Connecting from %s to %s", src, dest);
            final SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            Socket socket = socketChannel.socket();
            if (src != null) {
                socket.bind(src);
            }
            this.configureStream(socket);
            if (socketChannel.connect(dest)) {
                final NioSocketChannelImpl channel = new NioSocketChannelImpl(this.nioProvider, socketChannel, handler);
                this.executor.execute(new Runnable(){

                    public void run() {
                        log.trace("Connection from %s to %s is up (immediate)", src, dest);
                        if (!SpiUtils.handleOpened(handler, channel)) {
                            IoUtils.safeClose(socketChannel);
                        }
                    }
                });
                this.nioProvider.addChannel(channel);
                return new FinishedIoFuture<TcpChannel>(channel);
            }
            ConnectionHandler connectionHandler = new ConnectionHandler(this.executor, socketChannel, this.nioProvider, handler);
            connectionHandler.handle.getSelectionKey().interestOps(8).selector().wakeup();
            return connectionHandler.future;
        }
        catch (IOException e) {
            return new FailedIoFuture<TcpChannel>(e);
        }
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        if (option == null) {
            throw new NullPointerException("option is null");
        }
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.KEEP_ALIVE).equals(option)) {
            return (T)Boolean.valueOf(this.keepAlive);
        }
        if (((Object)CommonOptions.TCP_OOB_INLINE).equals(option)) {
            return (T)Boolean.valueOf(this.oobInline);
        }
        if (((Object)CommonOptions.RECEIVE_BUFFER).equals(option)) {
            int v = this.receiveBufferSize;
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        if (((Object)CommonOptions.REUSE_ADDRESSES).equals(option)) {
            return (T)Boolean.valueOf(this.reuseAddress);
        }
        if (((Object)CommonOptions.SEND_BUFFER).equals(option)) {
            int v = this.sendBufferSize;
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        if (((Object)CommonOptions.TCP_NODELAY).equals(option)) {
            return (T)Boolean.valueOf(this.tcpNoDelay);
        }
        throw new IllegalStateException("Failed to get supported option: " + option);
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return OPTIONS;
    }

    @Override
    public <T> TcpConnectorService setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == null) {
            throw new NullPointerException("name is null");
        }
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.KEEP_ALIVE).equals(option)) {
            this.setKeepAlive((Boolean)value);
            return this;
        }
        if (((Object)CommonOptions.TCP_OOB_INLINE).equals(option)) {
            this.setOobInline((Boolean)value);
            return this;
        }
        if (((Object)CommonOptions.RECEIVE_BUFFER).equals(option)) {
            this.setReceiveBufferSize((Integer)value);
            return this;
        }
        if (((Object)CommonOptions.REUSE_ADDRESSES).equals(option)) {
            this.setReuseAddress((Boolean)value);
            return this;
        }
        if (((Object)CommonOptions.SEND_BUFFER).equals(option)) {
            this.setSendBufferSize((Integer)value);
            return this;
        }
        if (((Object)CommonOptions.TCP_NODELAY).equals(option)) {
            this.setTcpNoDelay((Boolean)value);
            return this;
        }
        throw new IllegalStateException("Failed to set supported option: " + option);
    }

    static {
        HashSet<ChannelOption<Comparable<Boolean>>> options = new HashSet<ChannelOption<Comparable<Boolean>>>();
        options.add(CommonOptions.KEEP_ALIVE);
        options.add(CommonOptions.TCP_OOB_INLINE);
        options.add(CommonOptions.RECEIVE_BUFFER);
        options.add(CommonOptions.REUSE_ADDRESSES);
        options.add(CommonOptions.SEND_BUFFER);
        options.add(CommonOptions.TCP_NODELAY);
        OPTIONS = Collections.unmodifiableSet(options);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConnectionHandler
    implements Runnable {
        private final FutureImpl future;
        private final SocketChannel socketChannel;
        private final NioHandle handle;
        private final IoHandler<? super TcpChannel> handler;

        public ConnectionHandler(Executor executor, SocketChannel socketChannel, NioProvider nioProvider, IoHandler<? super TcpChannel> handler) throws IOException {
            this.socketChannel = socketChannel;
            this.handler = handler;
            this.handle = nioProvider.addConnectHandler(socketChannel, this);
            this.future = new FutureImpl(executor);
        }

        @Override
        public void run() {
            try {
                if (!this.socketChannel.finishConnect()) {
                    log.trace("Connection is not yet up (deferred)");
                    this.handle.getSelectionKey().interestOps(8).selector().wakeup();
                    return;
                }
                log.trace("Connection is up (deferred)");
                NioSocketChannelImpl channel = new NioSocketChannelImpl(NioTcpConnector.this.nioProvider, this.socketChannel, this.handler);
                this.future.setResult(channel);
                this.handler.handleOpened(channel);
                this.handle.cancelKey();
            }
            catch (IOException e) {
                this.future.setException(e);
                this.handle.cancelKey();
            }
            catch (Exception e) {
                String message = e.getMessage();
                IOException ioexception = new IOException("Connection failed unexpectedly: " + message);
                ioexception.setStackTrace(e.getStackTrace());
                this.future.setException(ioexception);
                this.handle.cancelKey();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class FutureImpl
        extends AbstractIoFuture<TcpChannel> {
            private final Executor executor;

            public FutureImpl(Executor executor) {
                this.executor = executor;
            }

            @Override
            protected boolean setException(IOException exception) {
                return super.setException(exception);
            }

            @Override
            protected boolean setResult(TcpChannel result) {
                return super.setResult(result);
            }

            @Override
            protected boolean finishCancel() {
                return super.finishCancel();
            }

            @Override
            protected void runNotifier(final IoFuture.Notifier<TcpChannel> streamChannelNotifier) {
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            streamChannelNotifier.notify(FutureImpl.this);
                        }
                        catch (Throwable t) {
                            log.error(t, "Completion handler \"%s\" failed", streamChannelNotifier);
                        }
                    }
                });
            }

            @Override
            public IoFuture<TcpChannel> cancel() {
                IoUtils.safeClose(ConnectionHandler.this.socketChannel);
                return this;
            }
        }
    }
}

