/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.Selector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.zip.ZipFile;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.CloseableExecutor;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IoUtils {
    private static final Logger log = Logger.getLogger(IoUtils.class);
    private static final Executor NULL_EXECUTOR = new Executor(){

        public void execute(Runnable command) {
        }
    };
    private static final Executor DIRECT_EXECUTOR = new Executor(){

        public void execute(Runnable command) {
            command.run();
        }
    };
    private static final IoHandler<Channel> NULL_HANDLER = new IoHandler<Channel>(){

        @Override
        public void handleOpened(Channel channel) {
        }

        @Override
        public void handleReadable(Channel channel) {
        }

        @Override
        public void handleWritable(Channel channel) {
        }

        @Override
        public void handleClosed(Channel channel) {
        }
    };
    private static final IoHandlerFactory<Channel> NULL_HANDLER_FACTORY = new IoHandlerFactory<Channel>(){

        @Override
        public IoHandler<Channel> createHandler() {
            return NULL_HANDLER;
        }
    };

    private IoUtils() {
    }

    public static <T extends StreamChannel> Closeable createConnection(ChannelSource<T> channelSource, IoHandler<? super T> handler, Executor reconnectExecutor) {
        Connection connection = new Connection(channelSource, handler, reconnectExecutor);
        connection.connect();
        return connection;
    }

    public static Executor delayedExecutor(final ScheduledExecutorService scheduledExecutorService, final long delay, final TimeUnit unit) {
        return new Executor(){

            public void execute(Runnable command) {
                scheduledExecutorService.schedule(command, delay, unit);
            }
        };
    }

    public static Executor directExecutor() {
        return DIRECT_EXECUTOR;
    }

    public static Executor nullExecutor() {
        return NULL_EXECUTOR;
    }

    public static CloseableExecutor closeableExecutor(final ExecutorService executorService, final long timeout, final TimeUnit unit) {
        return new CloseableExecutor(){

            public void close() throws IOException {
                executorService.shutdown();
                try {
                    if (executorService.awaitTermination(timeout, unit)) {
                        return;
                    }
                    executorService.shutdownNow();
                    throw new IOException("Executor did not shut down cleanly (killed)");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    executorService.shutdownNow();
                    throw new InterruptedIOException("Interrupted while awaiting executor shutdown");
                }
            }

            public void execute(Runnable command) {
                executorService.execute(command);
            }
        };
    }

    public static <T extends Channel> IoHandler<T> nullHandler() {
        return NULL_HANDLER;
    }

    public static <T extends Channel> IoHandlerFactory<T> nullHandlerFactory() {
        return NULL_HANDLER_FACTORY;
    }

    public static <T extends Channel> IoHandlerFactory<T> singletonHandlerFactory(IoHandler<T> handler) {
        final AtomicReference<IoHandler<T>> reference = new AtomicReference<IoHandler<T>>(handler);
        return new IoHandlerFactory<T>(){

            @Override
            public IoHandler<? super T> createHandler() {
                IoHandler handler = reference.getAndSet(null);
                if (handler == null) {
                    throw new IllegalStateException("Handler already taken from singleton handler factory");
                }
                return handler;
            }
        };
    }

    public static void safeClose(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            log.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(Socket resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            log.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(DatagramSocket resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            log.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(Selector resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            log.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(ServerSocket resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            log.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(ZipFile resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            log.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(Handler resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            log.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static <T> Future<T> getFuture(final IoFuture<T> ioFuture) {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                ioFuture.cancel();
                return ioFuture.await() == IoFuture.Status.CANCELLED;
            }

            @Override
            public boolean isCancelled() {
                return ioFuture.getStatus() == IoFuture.Status.CANCELLED;
            }

            @Override
            public boolean isDone() {
                return ioFuture.getStatus() == IoFuture.Status.DONE;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                try {
                    return ioFuture.getInterruptibly();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    if (ioFuture.awaitInterruptibly(unit, timeout) == IoFuture.Status.TIMED_OUT) {
                        throw new TimeoutException("Operation timed out");
                    }
                    return ioFuture.getInterruptibly();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Connection<T extends StreamChannel>
    implements Closeable {
        private final ChannelSource<T> channelSource;
        private final IoHandler<? super T> handler;
        private final Executor reconnectExecutor;
        private volatile boolean stopFlag = false;
        private volatile IoFuture<T> currentFuture;
        private final NotifierImpl notifier = new NotifierImpl();
        private final HandlerImpl handlerWrapper = new HandlerImpl();
        private final ReconnectTask reconnectTask = new ReconnectTask();

        private Connection(ChannelSource<T> channelSource, IoHandler<? super T> handler, Executor reconnectExecutor) {
            this.channelSource = channelSource;
            this.handler = handler;
            this.reconnectExecutor = reconnectExecutor;
        }

        private void connect() {
            log.trace("Establishing connection");
            IoFuture<T> ioFuture = this.channelSource.open(this.handlerWrapper);
            ioFuture.addNotifier(this.notifier);
            this.currentFuture = ioFuture;
        }

        @Override
        public void close() throws IOException {
            this.stopFlag = true;
            IoFuture<T> future = this.currentFuture;
            if (future != null) {
                future.cancel();
            }
        }

        private final class ReconnectTask
        implements Runnable {
            private ReconnectTask() {
            }

            public void run() {
                if (!Connection.this.stopFlag) {
                    Connection.this.connect();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class HandlerImpl
        implements IoHandler<T> {
            private HandlerImpl() {
            }

            @Override
            public void handleOpened(T channel) {
                Connection.this.handler.handleOpened(channel);
            }

            @Override
            public void handleReadable(T channel) {
                Connection.this.handler.handleReadable(channel);
            }

            @Override
            public void handleWritable(T channel) {
                Connection.this.handler.handleWritable(channel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleClosed(T channel) {
                try {
                    log.trace("Connection closed");
                    if (!Connection.this.stopFlag) {
                        Connection.this.reconnectExecutor.execute(Connection.this.reconnectTask);
                    }
                }
                finally {
                    Connection.this.handler.handleClosed(channel);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class NotifierImpl
        implements IoFuture.Notifier<T> {
            private NotifierImpl() {
            }

            @Override
            public void notify(IoFuture<T> future) {
                Connection.this.currentFuture = null;
                switch (future.getStatus()) {
                    case DONE: {
                        log.trace("Connection established");
                        return;
                    }
                    case FAILED: {
                        log.trace(future.getException(), "Connection failed", new Object[0]);
                        break;
                    }
                    case CANCELLED: {
                        log.trace("Connection cancelled");
                    }
                }
                if (!Connection.this.stopFlag) {
                    Connection.this.reconnectExecutor.execute(Connection.this.reconnectTask);
                }
            }
        }
    }
}

