/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.nio.channels.Channel;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HandlerUtils {
    private static final Logger handlerErrorLog = Logger.getLogger("org.jboss.xnio.handler-errors");

    private HandlerUtils() {
    }

    public static <T> boolean handleOpened(IoHandler<? super T> handler, T channel) {
        try {
            handler.handleOpened((Channel)channel);
            return true;
        }
        catch (Throwable t) {
            handlerErrorLog.error(t, "Channel handler open notification failed for handler %s, channel %s", handler, channel);
            return false;
        }
    }

    public static <T> boolean handleClosed(IoHandler<? super T> handler, T channel) {
        try {
            handler.handleClosed((Channel)channel);
            return true;
        }
        catch (Throwable t) {
            handlerErrorLog.error(t, "Channel handler close notification failed for handler %s, channel %s", handler, channel);
            return false;
        }
    }

    public static <T> boolean handleReadable(IoHandler<? super T> handler, T channel) {
        try {
            handler.handleReadable((Channel)channel);
            return true;
        }
        catch (Throwable t) {
            handlerErrorLog.error(t, "Channel handler readable notification failed for handler %s, channel %s", handler, channel);
            return false;
        }
    }

    public static <T> boolean handleWritable(IoHandler<? super T> handler, T channel) {
        try {
            handler.handleWritable((Channel)channel);
            return true;
        }
        catch (Throwable t) {
            handlerErrorLog.error(t, "Channel handler writable notification failed for handler %s, channel %s", handler, channel);
            return false;
        }
    }
}

