/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.lang.constant.Constable;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.Lifecycle;
import org.jboss.xnio.nio.NioProvider;
import org.jboss.xnio.nio.NioUdpSocketChannelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioUdpServer
implements Lifecycle,
Configurable {
    private static Logger log = Logger.getLogger(NioUdpServer.class);
    private NioProvider nioProvider;
    private IoHandlerFactory<? super UdpChannel> handlerFactory;
    private NioUdpSocketChannelImpl[] channels = new NioUdpSocketChannelImpl[0];
    private SocketAddress[] bindAddresses = new SocketAddress[0];
    private Executor executor;
    private int receiveBufferSize = -1;
    private boolean reuseAddress = false;
    private int sendBufferSize = -1;
    private int trafficClass = -1;
    private boolean broadcast = false;
    protected static final Set<ChannelOption<?>> OPTIONS;

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public SocketAddress[] getBindAddresses() {
        return this.bindAddresses;
    }

    public void setBindAddresses(SocketAddress[] bindAddresses) {
        this.bindAddresses = bindAddresses;
    }

    public NioProvider getNioProvider() {
        return this.nioProvider;
    }

    public void setNioProvider(NioProvider nioProvider) {
        this.nioProvider = nioProvider;
    }

    public IoHandlerFactory<? super UdpChannel> getHandlerFactory() {
        return this.handlerFactory;
    }

    public void setHandlerFactory(IoHandlerFactory<? super UdpChannel> handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public NioUdpSocketChannelImpl[] getChannels() {
        return this.channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        if (this.nioProvider == null) {
            throw new NullPointerException("nioProvider is null");
        }
        if (this.handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        int bindCount = this.bindAddresses.length;
        DatagramChannel[] datagramChannels = new DatagramChannel[bindCount];
        this.channels = new NioUdpSocketChannelImpl[bindCount];
        for (int i = 0; i < bindCount; ++i) {
            DatagramChannel datagramChannel = DatagramChannel.open();
            datagramChannel.configureBlocking(false);
            DatagramSocket socket = datagramChannel.socket();
            socket.setBroadcast(this.broadcast);
            if (this.receiveBufferSize != -1) {
                socket.setReceiveBufferSize(this.receiveBufferSize);
            }
            socket.setReuseAddress(this.reuseAddress);
            if (this.sendBufferSize != -1) {
                socket.setSendBufferSize(this.sendBufferSize);
            }
            if (this.trafficClass != -1) {
                socket.setTrafficClass(this.trafficClass);
            }
            datagramChannels[i] = datagramChannel;
            this.channels[i] = new NioUdpSocketChannelImpl(this.nioProvider, datagramChannel, this.handlerFactory.createHandler());
        }
        boolean ok = false;
        try {
            for (int i = 0; i < bindCount; ++i) {
                try {
                    datagramChannels[i].socket().bind(this.bindAddresses[i]);
                }
                catch (IOException ex) {
                    log.error("Unable to bind to %s: %s", this.bindAddresses[i], ex);
                    IoUtils.safeClose(datagramChannels[i]);
                    continue;
                }
                NioUdpSocketChannelImpl channel = this.channels[i];
                if (!HandlerUtils.handleOpened(channel.getHandler(), channel)) {
                    IoUtils.safeClose(datagramChannels[i]);
                }
                this.nioProvider.addChannel(channel);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (int j = 0; j < bindCount; ++j) {
                    IoUtils.safeClose(datagramChannels[j]);
                    if (this.channels[j] == null) continue;
                    this.nioProvider.removeChannel(this.channels[j]);
                }
                this.channels = null;
            }
        }
    }

    @Override
    public void stop() {
        if (this.channels != null) {
            for (NioUdpSocketChannelImpl channel : this.channels) {
                IoUtils.safeClose(channel);
            }
            this.channels = null;
        }
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.RECEIVE_BUFFER).equals(option)) {
            int v = this.receiveBufferSize;
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        if (((Object)CommonOptions.REUSE_ADDRESSES).equals(option)) {
            return (T)Boolean.valueOf(this.reuseAddress);
        }
        if (((Object)CommonOptions.SEND_BUFFER).equals(option)) {
            int v = this.sendBufferSize;
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        if (((Object)CommonOptions.IP_TRAFFIC_CLASS).equals(option)) {
            int v = this.trafficClass;
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        if (((Object)CommonOptions.BROADCAST).equals(option)) {
            return (T)Boolean.valueOf(this.broadcast);
        }
        throw new IllegalStateException("Failed to get supported option: " + option);
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return OPTIONS;
    }

    @Override
    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (((Object)CommonOptions.RECEIVE_BUFFER).equals(option)) {
            this.setReceiveBufferSize((Integer)value);
            return this;
        }
        if (((Object)CommonOptions.REUSE_ADDRESSES).equals(option)) {
            this.setReuseAddress((Boolean)value);
            return this;
        }
        if (((Object)CommonOptions.SEND_BUFFER).equals(option)) {
            this.setSendBufferSize((Integer)value);
            return this;
        }
        if (((Object)CommonOptions.IP_TRAFFIC_CLASS).equals(option)) {
            this.setTrafficClass((Integer)value);
            return this;
        }
        if (((Object)CommonOptions.BROADCAST).equals(option)) {
            this.setBroadcast((Boolean)value);
            return this;
        }
        throw new IllegalStateException("Failed to set supported option: " + option);
    }

    public String toString() {
        return String.format("UDP server (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    static {
        HashSet<ChannelOption<Constable>> options = new HashSet<ChannelOption<Constable>>();
        options.add(CommonOptions.RECEIVE_BUFFER);
        options.add(CommonOptions.REUSE_ADDRESSES);
        options.add(CommonOptions.SEND_BUFFER);
        options.add(CommonOptions.IP_TRAFFIC_CLASS);
        options.add(CommonOptions.BROADCAST);
        OPTIONS = Collections.unmodifiableSet(options);
    }
}

