/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.DatagramChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.MultipointReadResult;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioUdpSocketChannelImpl
implements UdpChannel {
    private final DatagramChannel datagramChannel;
    private final NioHandle readHandle;
    private final NioHandle writeHandle;
    private final IoHandler<? super UdpChannel> handler;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private final NioProvider nioProvider;

    public NioUdpSocketChannelImpl(NioProvider nioProvider, DatagramChannel datagramChannel, IoHandler<? super UdpChannel> handler) throws IOException {
        this.nioProvider = nioProvider;
        this.readHandle = nioProvider.addReadHandler(datagramChannel, new ReadHandler());
        this.writeHandle = nioProvider.addWriteHandler(datagramChannel, new WriteHandler());
        this.datagramChannel = datagramChannel;
        this.handler = handler;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.datagramChannel.socket().getLocalSocketAddress();
    }

    @Override
    public MultipointReadResult<SocketAddress> receive(ByteBuffer buffer) throws IOException {
        final SocketAddress sourceAddress = this.datagramChannel.receive(buffer);
        return sourceAddress == null ? null : new MultipointReadResult<SocketAddress>(){

            @Override
            public SocketAddress getSourceAddress() {
                return sourceAddress;
            }

            @Override
            public SocketAddress getDestinationAddress() {
                return null;
            }
        };
    }

    @Override
    public boolean isOpen() {
        return this.datagramChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.datagramChannel.close();
        }
        finally {
            this.nioProvider.removeChannel(this);
            this.readHandle.cancelKey();
            this.writeHandle.cancelKey();
            if (!this.callFlag.getAndSet(true)) {
                HandlerUtils.handleClosed(this.handler, this);
            }
        }
    }

    @Override
    public boolean send(SocketAddress target, ByteBuffer buffer) throws IOException {
        return this.datagramChannel.send(buffer, target) != 0;
    }

    @Override
    public boolean send(SocketAddress target, ByteBuffer[] dsts) throws IOException {
        return this.send(target, dsts, 0, dsts.length);
    }

    @Override
    public boolean send(SocketAddress target, ByteBuffer[] dsts, int offset, int length) throws IOException {
        long total = 0L;
        for (int i = 0; i < length; ++i) {
            total += (long)dsts[offset + i].remaining();
        }
        if (total > Integer.MAX_VALUE) {
            throw new IOException("Source data is too large");
        }
        ByteBuffer buf = ByteBuffer.allocate((int)total);
        for (int i = 0; i < length; ++i) {
            buf.put(dsts[offset + i]);
        }
        buf.flip();
        return this.send(target, buf);
    }

    @Override
    public void suspendReads() {
        try {
            this.readHandle.getSelectionKey().interestOps(0).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void suspendWrites() {
        try {
            this.writeHandle.getSelectionKey().interestOps(0).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void resumeReads() {
        try {
            this.readHandle.getSelectionKey().interestOps(1).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void resumeWrites() {
        try {
            this.writeHandle.getSelectionKey().interestOps(4).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void shutdownReads() throws IOException {
        throw new UnsupportedOperationException("Shutdown reads");
    }

    @Override
    public void shutdownWrites() throws IOException {
        throw new UnsupportedOperationException("Shutdown writes");
    }

    @Override
    public UdpChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        throw new UnsupportedOperationException("Multicast join");
    }

    @Override
    public UdpChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source) throws IOException {
        throw new UnsupportedOperationException("Multicast join");
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return Collections.emptySet();
    }

    @Override
    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    public IoHandler<? super UdpChannel> getHandler() {
        return this.handler;
    }

    public String toString() {
        return String.format("UDP socket channel (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    public final class WriteHandler
    implements Runnable {
        public void run() {
            HandlerUtils.handleWritable(NioUdpSocketChannelImpl.this.handler, NioUdpSocketChannelImpl.this);
        }
    }

    public final class ReadHandler
    implements Runnable {
        public void run() {
            HandlerUtils.handleReadable(NioUdpSocketChannelImpl.this.handler, NioUdpSocketChannelImpl.this);
        }
    }
}

