/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IoFuture<T> {
    public IoFuture<T> cancel();

    public Status getStatus();

    public Status await();

    public Status await(long var1, TimeUnit var3);

    public Status awaitInterruptibly() throws InterruptedException;

    public Status awaitInterruptibly(long var1, TimeUnit var3) throws InterruptedException;

    public T get() throws IOException, CancellationException;

    public T getInterruptibly() throws IOException, InterruptedException, CancellationException;

    public IOException getException() throws IllegalStateException;

    public void addNotifier(Notifier<T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class HandlingNotifier<T>
    implements Notifier<T> {
        @Override
        public void notify(IoFuture<T> future) {
            switch (future.getStatus()) {
                case CANCELLED: {
                    this.handleCancelled();
                    break;
                }
                case DONE: {
                    try {
                        this.handleDone(future.get());
                        break;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException();
                    }
                }
                case FAILED: {
                    this.handleFailed(future.getException());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public void handleCancelled() {
        }

        public void handleFailed(IOException exception) {
        }

        public void handleDone(T result) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Notifier<T> {
        public void notify(IoFuture<T> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        WAITING,
        DONE,
        CANCELLED,
        FAILED;

        @Deprecated
        public static final Status TIMED_OUT;

        static {
            TIMED_OUT = WAITING;
        }
    }
}

