/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.CloseableTcpConnector;
import org.jboss.xnio.ConfigurableFactory;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UdpChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Xnio
implements Closeable {
    private static final String NIO_IMPL_CLASS_NAME = "org.jboss.xnio.nio.NioXnio";
    private static final String PROVIDER_CLASS;

    public static Xnio create() throws IOException {
        return Xnio.createInstance(PROVIDER_CLASS, new Class[0], new Object[0]);
    }

    private static Xnio createInstance(String className, Class[] paramTypes, Object ... params) throws IOException {
        try {
            Class<Xnio> xnioClass = Class.forName(className).asSubclass(Xnio.class);
            Constructor<Xnio> constructor = xnioClass.getConstructor(paramTypes);
            return constructor.newInstance(params);
        }
        catch (ClassCastException e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" is not really an XNIO provider");
            ioe.initCause(e);
            throw ioe;
        }
        catch (ClassNotFoundException e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" was not found");
            ioe.initCause(e);
            throw ioe;
        }
        catch (IllegalAccessException e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" was not instantiatable due to an illegal access exception");
            ioe.initCause(e);
            throw ioe;
        }
        catch (InstantiationException e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" was not instantiatable due to an instantiation exception");
            ioe.initCause(e);
            throw ioe;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" constructor threw an exception");
            ioe.initCause(cause);
            throw ioe;
        }
        catch (NoSuchMethodException e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" does not have an accessible no-argument constructor");
            ioe.initCause(e);
            throw ioe;
        }
        catch (ExceptionInInitializerError e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" was not instantiatable due to an error in initialization");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected Xnio() {
    }

    @Deprecated
    public static Xnio createNio() throws IOException {
        return Xnio.createInstance(NIO_IMPL_CLASS_NAME, new Class[0], new Object[0]);
    }

    @Deprecated
    public static Xnio createNio(int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        return Xnio.createInstance(NIO_IMPL_CLASS_NAME, new Class[]{Integer.class, Integer.class, Integer.class}, readSelectorThreads, writeSelectorThreads, connectSelectorThreads);
    }

    @Deprecated
    public static Xnio createNio(Executor handlerExecutor, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        return Xnio.createInstance(NIO_IMPL_CLASS_NAME, new Class[]{Executor.class, Integer.class, Integer.class, Integer.class}, handlerExecutor, readSelectorThreads, writeSelectorThreads, connectSelectorThreads);
    }

    @Deprecated
    public static Xnio createNio(Executor handlerExecutor, ThreadFactory selectorThreadFactory, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        return Xnio.createInstance(NIO_IMPL_CLASS_NAME, new Class[]{Executor.class, ThreadFactory.class, Integer.class, Integer.class, Integer.class}, handlerExecutor, selectorThreadFactory, readSelectorThreads, writeSelectorThreads, connectSelectorThreads);
    }

    public ConfigurableFactory<Closeable> createTcpServer(Executor executor, IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        throw new UnsupportedOperationException("TCP Server");
    }

    public ConfigurableFactory<Closeable> createTcpServer(IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        throw new UnsupportedOperationException("TCP Server");
    }

    public ConfigurableFactory<CloseableTcpConnector> createTcpConnector(Executor executor) {
        throw new UnsupportedOperationException("TCP Connector");
    }

    public ConfigurableFactory<CloseableTcpConnector> createTcpConnector() {
        throw new UnsupportedOperationException("TCP Connector");
    }

    public ConfigurableFactory<Closeable> createUdpServer(Executor executor, boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        throw new UnsupportedOperationException("UDP Server");
    }

    public ConfigurableFactory<Closeable> createUdpServer(boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        throw new UnsupportedOperationException("UDP Server");
    }

    public ChannelSource<StreamChannel> createPipeServer(IoHandlerFactory<? super StreamChannel> handlerFactory) {
        throw new UnsupportedOperationException("Pipe Server");
    }

    public ChannelSource<StreamSourceChannel> createPipeSourceServer(IoHandlerFactory<? super StreamSinkChannel> handlerFactory) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public ChannelSource<StreamSinkChannel> createPipeSinkServer(IoHandlerFactory<? super StreamSourceChannel> handlerFactory) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public IoFuture<Closeable> createPipeConnection(IoHandler<? super StreamChannel> leftHandler, IoHandler<? super StreamChannel> rightHandler) {
        throw new UnsupportedOperationException("Pipe Connection");
    }

    public IoFuture<Closeable> createOneWayPipeConnection(IoHandler<? super StreamSourceChannel> sourceHandler, IoHandler<? super StreamSinkChannel> sinkHandler) {
        throw new UnsupportedOperationException("One-way Pipe Connection");
    }

    @Override
    public abstract void close() throws IOException;

    static {
        String providerClassName = NIO_IMPL_CLASS_NAME;
        try {
            providerClassName = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("xnio.provider", Xnio.NIO_IMPL_CLASS_NAME);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PROVIDER_CLASS = providerClassName;
    }
}

