/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Pipe;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioPipeSinkChannelImpl
implements StreamSinkChannel {
    private final Pipe.SinkChannel channel;
    private final NioHandle handle;
    private final NioProvider nioProvider;
    private final IoHandler<? super StreamSinkChannel> handler;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);

    public NioPipeSinkChannelImpl(Pipe.SinkChannel channel, IoHandler<? super StreamSinkChannel> handler, NioProvider nioProvider) throws IOException {
        this.channel = channel;
        this.handler = handler;
        this.nioProvider = nioProvider;
        this.handle = nioProvider.addWriteHandler(channel, new Handler());
    }

    @Override
    public int write(ByteBuffer dst) throws IOException {
        return this.channel.write(dst);
    }

    @Override
    public long write(ByteBuffer[] dsts) throws IOException {
        return this.channel.write(dsts);
    }

    @Override
    public long write(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.channel.write(dsts, offset, length);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        finally {
            this.nioProvider.removeChannel(this);
            this.handle.cancelKey();
            if (!this.callFlag.getAndSet(true)) {
                HandlerUtils.handleClosed(this.handler, this);
            }
        }
    }

    @Override
    public void suspendWrites() {
        try {
            this.handle.getSelectionKey().interestOps(0).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void resumeWrites() {
        try {
            this.handle.getSelectionKey().interestOps(4).selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.channel.close();
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    @Override
    public Set<ChannelOption<?>> getOptions() {
        return Collections.emptySet();
    }

    @Override
    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    public String toString() {
        return String.format("pipe sink channel (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    private final class Handler
    implements Runnable {
        private Handler() {
        }

        public void run() {
            HandlerUtils.handleWritable(NioPipeSinkChannelImpl.this.handler, NioPipeSinkChannelImpl.this);
        }
    }
}

