/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.nio.channels.Pipe;
import java.util.concurrent.Executor;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.Lifecycle;
import org.jboss.xnio.nio.NioPipeChannelImpl;
import org.jboss.xnio.nio.NioProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioPipeConnection
implements Lifecycle {
    private NioProvider nioProvider;
    private IoHandler<? super StreamChannel> leftHandler;
    private IoHandler<? super StreamChannel> rightHandler;
    private NioPipeChannelImpl leftSide;
    private NioPipeChannelImpl rightSide;
    private Executor executor;
    private Executor leftSideExecutor;
    private Executor rightSideExecutor;

    public NioProvider getNioProvider() {
        return this.nioProvider;
    }

    public void setNioProvider(NioProvider nioProvider) {
        this.nioProvider = nioProvider;
    }

    public NioPipeChannelImpl getLeftSide() {
        return this.leftSide;
    }

    public void setLeftSide(NioPipeChannelImpl leftSide) {
        this.leftSide = leftSide;
    }

    public NioPipeChannelImpl getRightSide() {
        return this.rightSide;
    }

    public void setRightSide(NioPipeChannelImpl rightSide) {
        this.rightSide = rightSide;
    }

    public IoHandler<? super StreamChannel> getLeftHandler() {
        return this.leftHandler;
    }

    public void setLeftHandler(IoHandler<? super StreamChannel> leftHandler) {
        this.leftHandler = leftHandler;
    }

    public IoHandler<? super StreamChannel> getRightHandler() {
        return this.rightHandler;
    }

    public void setRightHandler(IoHandler<? super StreamChannel> rightHandler) {
        this.rightHandler = rightHandler;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getLeftSideExecutor() {
        return this.leftSideExecutor;
    }

    public void setLeftSideExecutor(Executor leftSideExecutor) {
        this.leftSideExecutor = leftSideExecutor;
    }

    public Executor getRightSideExecutor() {
        return this.rightSideExecutor;
    }

    public void setRightSideExecutor(Executor rightSideExecutor) {
        this.rightSideExecutor = rightSideExecutor;
    }

    @Override
    public void start() throws IOException {
        if (this.leftHandler == null) {
            throw new NullPointerException("leftHandler is null");
        }
        if (this.rightHandler == null) {
            throw new NullPointerException("rightHandler is null");
        }
        if (this.nioProvider == null) {
            throw new NullPointerException("nioProvider is null");
        }
        if (this.executor == null) {
            this.executor = this.nioProvider.getExecutor();
        }
        if (this.leftSideExecutor == null) {
            this.leftSideExecutor = this.executor;
        }
        if (this.rightSideExecutor == null) {
            this.rightSideExecutor = this.executor;
        }
        Pipe leftToRight = Pipe.open();
        Pipe rightToLeft = Pipe.open();
        final Pipe.SourceChannel leftToRightSource = leftToRight.source();
        final Pipe.SinkChannel leftToRightSink = rightToLeft.sink();
        final Pipe.SourceChannel rightToLeftSource = rightToLeft.source();
        final Pipe.SinkChannel rightToLeftSink = leftToRight.sink();
        leftToRightSource.configureBlocking(false);
        leftToRightSink.configureBlocking(false);
        rightToLeftSource.configureBlocking(false);
        rightToLeftSink.configureBlocking(false);
        final NioPipeChannelImpl leftSide = new NioPipeChannelImpl(leftToRightSource, leftToRightSink, this.leftHandler, this.nioProvider);
        final NioPipeChannelImpl rightSide = new NioPipeChannelImpl(rightToLeftSource, rightToLeftSink, this.rightHandler, this.nioProvider);
        this.leftSide = leftSide;
        this.rightSide = rightSide;
        this.leftSideExecutor.execute(new Runnable(){

            public void run() {
                if (!HandlerUtils.handleOpened(NioPipeConnection.this.leftHandler, leftSide)) {
                    IoUtils.safeClose(leftToRightSource);
                    IoUtils.safeClose(leftToRightSink);
                    IoUtils.safeClose(rightToLeftSource);
                    IoUtils.safeClose(rightToLeftSink);
                }
            }
        });
        this.rightSideExecutor.execute(new Runnable(){

            public void run() {
                if (!HandlerUtils.handleOpened(NioPipeConnection.this.rightHandler, rightSide)) {
                    IoUtils.safeClose(leftToRightSource);
                    IoUtils.safeClose(leftToRightSink);
                    IoUtils.safeClose(rightToLeftSource);
                    IoUtils.safeClose(rightToLeftSink);
                }
            }
        });
        this.nioProvider.addChannel(leftSide);
        this.nioProvider.addChannel(rightSide);
    }

    @Override
    public void stop() throws IOException {
        IoUtils.safeClose(this.leftSide);
        IoUtils.safeClose(this.rightSide);
        this.leftSide = null;
        this.rightSide = null;
    }
}

