/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.SelectorTask;

public final class NioSelectorRunnable
implements Runnable {
    private static final Logger log = Logger.getLogger(NioSelectorRunnable.class);
    private final Selector selector;
    private final Queue<SelectorTask> selectorWorkQueue = new LinkedList<SelectorTask>();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private volatile int keyLoad;
    private volatile Thread thread;

    protected NioSelectorRunnable() throws IOException {
        this.selector = Selector.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueTask(SelectorTask task) {
        Queue<SelectorTask> queue = this.selectorWorkQueue;
        synchronized (queue) {
            this.selectorWorkQueue.add(task);
        }
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    public int getKeyLoad() {
        return this.keyLoad;
    }

    public void shutdown() {
        if (!this.shutdown.getAndSet(true)) {
            try {
                this.selector.close();
            }
            catch (Throwable t) {
                log.trace(t, "Failed to close selector", new Object[0]);
            }
            Thread thread = this.thread;
            if (thread != null && thread != Thread.currentThread()) {
                try {
                    thread.interrupt();
                }
                catch (Throwable t) {
                    log.trace(t, "Failed to interrupt selector thread", new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Selector selector = this.selector;
        Queue<SelectorTask> queue = this.selectorWorkQueue;
        while (true) {
            try {
                block12: while (true) {
                    if (this.shutdown.get()) {
                        return;
                    }
                    this.keyLoad = selector.keys().size();
                    selector.select();
                    Queue<SelectorTask> queue2 = queue;
                    synchronized (queue2) {
                        while (!queue.isEmpty()) {
                            SelectorTask task = queue.remove();
                            try {
                                task.run(selector);
                            }
                            catch (Throwable t) {
                                log.trace(t, "NIO selector task failed", new Object[0]);
                            }
                        }
                    }
                    Set<SelectionKey> selectedKeys = selector.selectedKeys();
                    Iterator<SelectionKey> iterator = selectedKeys.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block12;
                        SelectionKey key = iterator.next();
                        iterator.remove();
                        try {
                            key.interestOps(key.interestOps() & 0x10);
                            try {
                                NioHandle handle = (NioHandle)key.attachment();
                                handle.getHandlerExecutor().execute(handle.getHandler());
                            }
                            catch (Throwable t) {
                                log.trace(t, "Failed to execute handler", new Object[0]);
                            }
                        }
                        catch (CancelledKeyException e) {
                            log.trace("Key %s cancelled", key);
                        }
                    }
                    break;
                }
            }
            catch (ClosedSelectorException e) {
                log.trace("Selector %s closed", selector);
                return;
            }
            catch (IOException e) {
                log.trace(e, "I/O error in selector loop", new Object[0]);
                continue;
            }
            break;
        }
    }
}

