/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.CloseableTcpConnector;
import org.jboss.xnio.ConfigurableFactory;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.FinishedIoFuture;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.TcpChannelSource;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.Xnio;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.nio.BioMulticastServer;
import org.jboss.xnio.nio.Lifecycle;
import org.jboss.xnio.nio.NioOneWayPipeConnection;
import org.jboss.xnio.nio.NioPipeConnection;
import org.jboss.xnio.nio.NioProvider;
import org.jboss.xnio.nio.NioTcpConnector;
import org.jboss.xnio.nio.NioTcpServer;
import org.jboss.xnio.nio.NioUdpServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioXnio
extends Xnio {
    private final NioProvider provider;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Object lifecycleLock;

    public static Xnio create() throws IOException {
        return new NioXnio(null, null, 1, 1, 1);
    }

    public static Xnio create(int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        return new NioXnio(null, null, readSelectorThreads, writeSelectorThreads, connectSelectorThreads);
    }

    public static Xnio create(Executor handlerExecutor, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        if (handlerExecutor == null) {
            throw new NullPointerException("handlerExecutor is null");
        }
        return new NioXnio(handlerExecutor, null, readSelectorThreads, writeSelectorThreads, connectSelectorThreads);
    }

    public static Xnio create(Executor handlerExecutor, ThreadFactory selectorThreadFactory, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        if (handlerExecutor == null) {
            throw new NullPointerException("handlerExecutor is null");
        }
        if (selectorThreadFactory == null) {
            throw new NullPointerException("selectorThreadFactory is null");
        }
        return new NioXnio(handlerExecutor, selectorThreadFactory, readSelectorThreads, writeSelectorThreads, connectSelectorThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NioXnio(Executor handlerExecutor, ThreadFactory selectorThreadFactory, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        Object object = this.lifecycleLock = new Object();
        synchronized (object) {
            NioProvider provider = new NioProvider();
            if (handlerExecutor != null) {
                provider.setExecutor(handlerExecutor);
            }
            if (selectorThreadFactory != null) {
                provider.setSelectorThreadFactory(selectorThreadFactory);
            }
            provider.setReadSelectorThreads(readSelectorThreads);
            provider.setWriteSelectorThreads(writeSelectorThreads);
            provider.setConnectionSelectorThreads(connectSelectorThreads);
            provider.start();
            this.provider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableFactory<Closeable> createTcpServer(Executor executor, IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        NioTcpServer nioTcpServer;
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (bindAddresses == null) {
            throw new NullPointerException("bindAddresses is null");
        }
        if (bindAddresses.length == 0) {
            throw new IllegalArgumentException("no bind addresses specified");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            nioTcpServer = new NioTcpServer();
            nioTcpServer.setNioProvider(this.provider);
            nioTcpServer.setExecutor(executor);
            nioTcpServer.setBindAddresses(bindAddresses);
            nioTcpServer.setHandlerFactory(handlerFactory);
        }
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, nioTcpServer, started, new LifecycleCloseable(nioTcpServer, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableFactory<Closeable> createTcpServer(IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        NioTcpServer nioTcpServer;
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (bindAddresses == null) {
            throw new NullPointerException("bindAddresses is null");
        }
        if (bindAddresses.length == 0) {
            throw new IllegalArgumentException("no bind addresses specified");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            nioTcpServer = new NioTcpServer();
            nioTcpServer.setNioProvider(this.provider);
            nioTcpServer.setBindAddresses(bindAddresses);
            nioTcpServer.setHandlerFactory(handlerFactory);
        }
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, nioTcpServer, started, new LifecycleCloseable(nioTcpServer, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableFactory<CloseableTcpConnector> createTcpConnector(Executor executor) {
        NioTcpConnector nioTcpConnector;
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            nioTcpConnector = new NioTcpConnector();
            nioTcpConnector.setNioProvider(this.provider);
            nioTcpConnector.setExecutor(executor);
        }
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, nioTcpConnector, started, new LifecycleConnector(this, nioTcpConnector, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableFactory<CloseableTcpConnector> createTcpConnector() {
        NioTcpConnector nioTcpConnector;
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            nioTcpConnector = new NioTcpConnector();
            nioTcpConnector.setNioProvider(this.provider);
        }
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, nioTcpConnector, started, new LifecycleConnector(this, nioTcpConnector, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableFactory<Closeable> createUdpServer(Executor executor, boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        NioUdpServer nioUdpServer;
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (bindAddresses == null) {
            throw new NullPointerException("bindAddresses is null");
        }
        if (bindAddresses.length == 0) {
            throw new IllegalArgumentException("no bind addresses specified");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        if (multicast) {
            BioMulticastServer bioMulticastServer;
            Object object = this.lifecycleLock;
            synchronized (object) {
                bioMulticastServer = new BioMulticastServer();
                bioMulticastServer.setBindAddresses(bindAddresses);
                bioMulticastServer.setExecutor(executor);
                bioMulticastServer.setHandlerFactory(handlerFactory);
            }
            AtomicBoolean started = new AtomicBoolean(false);
            AtomicBoolean stopped = new AtomicBoolean(false);
            return new SimpleConfigurableFactory(this, bioMulticastServer, started, new LifecycleCloseable(bioMulticastServer, stopped));
        }
        Object started = this.lifecycleLock;
        synchronized (started) {
            nioUdpServer = new NioUdpServer();
            nioUdpServer.setNioProvider(this.provider);
            nioUdpServer.setBindAddresses(bindAddresses);
            nioUdpServer.setExecutor(executor);
            nioUdpServer.setHandlerFactory(handlerFactory);
        }
        started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, nioUdpServer, (AtomicBoolean)started, new LifecycleCloseable(nioUdpServer, stopped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableFactory<Closeable> createUdpServer(boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        NioUdpServer nioUdpServer;
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (bindAddresses == null) {
            throw new NullPointerException("bindAddresses is null");
        }
        if (bindAddresses.length == 0) {
            throw new IllegalArgumentException("no bind addresses specified");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        if (multicast) {
            BioMulticastServer bioMulticastServer;
            Object object = this.lifecycleLock;
            synchronized (object) {
                bioMulticastServer = new BioMulticastServer();
                bioMulticastServer.setBindAddresses(bindAddresses);
                bioMulticastServer.setHandlerFactory(handlerFactory);
            }
            AtomicBoolean started = new AtomicBoolean(false);
            AtomicBoolean stopped = new AtomicBoolean(false);
            return new SimpleConfigurableFactory(this, bioMulticastServer, started, new LifecycleCloseable(bioMulticastServer, stopped));
        }
        Object started = this.lifecycleLock;
        synchronized (started) {
            nioUdpServer = new NioUdpServer();
            nioUdpServer.setNioProvider(this.provider);
            nioUdpServer.setBindAddresses(bindAddresses);
            nioUdpServer.setHandlerFactory(handlerFactory);
        }
        started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(false);
        return new SimpleConfigurableFactory(this, nioUdpServer, (AtomicBoolean)started, new LifecycleCloseable(nioUdpServer, stopped));
    }

    @Override
    public ChannelSource<StreamChannel> createPipeServer(final IoHandlerFactory<? super StreamChannel> handlerFactory) {
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        return new ChannelSource<StreamChannel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IoFuture<StreamChannel> open(IoHandler<? super StreamChannel> handler) {
                Object object = NioXnio.this.lifecycleLock;
                synchronized (object) {
                    NioPipeConnection nioPipeConnection = new NioPipeConnection();
                    nioPipeConnection.setNioProvider(NioXnio.this.provider);
                    nioPipeConnection.setRightHandler(handlerFactory.createHandler());
                    nioPipeConnection.setLeftHandler(handler);
                    try {
                        nioPipeConnection.start();
                    }
                    catch (IOException e) {
                        return new FailedIoFuture<StreamChannel>(e);
                    }
                    return new FinishedIoFuture<StreamChannel>(nioPipeConnection.getLeftSide());
                }
            }
        };
    }

    @Override
    public ChannelSource<StreamSourceChannel> createPipeSourceServer(final IoHandlerFactory<? super StreamSinkChannel> handlerFactory) {
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        return new ChannelSource<StreamSourceChannel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IoFuture<StreamSourceChannel> open(IoHandler<? super StreamSourceChannel> handler) {
                Object object = NioXnio.this.lifecycleLock;
                synchronized (object) {
                    NioOneWayPipeConnection nioPipeConnection = new NioOneWayPipeConnection();
                    nioPipeConnection.setNioProvider(NioXnio.this.provider);
                    nioPipeConnection.setSinkHandler(handlerFactory.createHandler());
                    nioPipeConnection.setSourceHandler(handler);
                    try {
                        nioPipeConnection.start();
                    }
                    catch (IOException e) {
                        return new FailedIoFuture<StreamSourceChannel>(e);
                    }
                    return new FinishedIoFuture<StreamSourceChannel>(nioPipeConnection.getSourceSide());
                }
            }
        };
    }

    @Override
    public ChannelSource<StreamSinkChannel> createPipeSinkServer(final IoHandlerFactory<? super StreamSourceChannel> handlerFactory) {
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        return new ChannelSource<StreamSinkChannel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IoFuture<StreamSinkChannel> open(IoHandler<? super StreamSinkChannel> handler) {
                Object object = NioXnio.this.lifecycleLock;
                synchronized (object) {
                    NioOneWayPipeConnection nioPipeConnection = new NioOneWayPipeConnection();
                    nioPipeConnection.setNioProvider(NioXnio.this.provider);
                    nioPipeConnection.setSourceHandler(handlerFactory.createHandler());
                    nioPipeConnection.setSinkHandler(handler);
                    try {
                        nioPipeConnection.start();
                    }
                    catch (IOException e) {
                        return new FailedIoFuture<StreamSinkChannel>(e);
                    }
                    return new FinishedIoFuture<StreamSinkChannel>(nioPipeConnection.getSinkSide());
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture<Closeable> createPipeConnection(IoHandler<? super StreamChannel> leftHandler, IoHandler<? super StreamChannel> rightHandler) {
        if (leftHandler == null) {
            throw new NullPointerException("leftHandler is null");
        }
        if (rightHandler == null) {
            throw new NullPointerException("rightHandler is null");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            NioPipeConnection nioPipeConnection = new NioPipeConnection();
            nioPipeConnection.setNioProvider(this.provider);
            nioPipeConnection.setLeftHandler(leftHandler);
            nioPipeConnection.setRightHandler(rightHandler);
            try {
                nioPipeConnection.start();
            }
            catch (IOException e) {
                return new FailedIoFuture<Closeable>(e);
            }
            return new FinishedIoFuture<Closeable>(new LifecycleCloseable(nioPipeConnection, new AtomicBoolean(false)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture<Closeable> createOneWayPipeConnection(IoHandler<? super StreamSourceChannel> sourceHandler, IoHandler<? super StreamSinkChannel> sinkHandler) {
        if (sourceHandler == null) {
            throw new NullPointerException("sourceHandler is null");
        }
        if (sinkHandler == null) {
            throw new NullPointerException("sinkHandler is null");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("XNIO provider not open");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            NioOneWayPipeConnection nioOneWayPipeConnection = new NioOneWayPipeConnection();
            nioOneWayPipeConnection.setNioProvider(this.provider);
            nioOneWayPipeConnection.setSourceHandler(sourceHandler);
            nioOneWayPipeConnection.setSinkHandler(sinkHandler);
            try {
                nioOneWayPipeConnection.start();
            }
            catch (IOException e) {
                return new FailedIoFuture<Closeable>(e);
            }
            return new FinishedIoFuture<Closeable>(new LifecycleCloseable(nioOneWayPipeConnection, new AtomicBoolean(false)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            Object object = this.lifecycleLock;
            synchronized (object) {
                this.provider.stop();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleConfigurableFactory<Q, Z extends Configurable & Lifecycle>
    implements ConfigurableFactory<Q> {
        private final AtomicBoolean started;
        private final Q resource;
        private final Z configurableLifecycle;
        final /* synthetic */ NioXnio this$0;

        private SimpleConfigurableFactory(Z configurableLifecycle, AtomicBoolean started, Q resource) {
            this.this$0 = var1_1;
            this.started = started;
            this.resource = resource;
            this.configurableLifecycle = configurableLifecycle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Q create() throws IOException {
            if (this.started.get()) {
                throw new IllegalStateException("Already created");
            }
            Object object = this.this$0.lifecycleLock;
            synchronized (object) {
                ((Lifecycle)this.configurableLifecycle).start();
            }
            return this.resource;
        }

        @Override
        public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
            return this.configurableLifecycle.getOption(option);
        }

        @Override
        public Set<ChannelOption<?>> getOptions() {
            return this.configurableLifecycle.getOptions();
        }

        @Override
        public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
            if (this.started.get()) {
                throw new IllegalStateException("Already created");
            }
            this.configurableLifecycle.setOption(option, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LifecycleConnector
    extends LifecycleCloseable
    implements CloseableTcpConnector {
        private final AtomicBoolean closed;
        private final TcpConnector realConnector;
        final /* synthetic */ NioXnio this$0;

        private <T extends Lifecycle & TcpConnector> LifecycleConnector(T lifecycle, AtomicBoolean closed) {
            this.this$0 = var1_1;
            super(lifecycle, closed);
            this.closed = closed;
            this.realConnector = lifecycle;
        }

        @Override
        public IoFuture<TcpChannel> connectTo(SocketAddress dest, IoHandler<? super TcpChannel> ioHandler) {
            if (this.closed.get()) {
                throw new IllegalStateException("Connector closed");
            }
            return this.realConnector.connectTo(dest, ioHandler);
        }

        @Override
        public IoFuture<TcpChannel> connectTo(SocketAddress src, SocketAddress dest, IoHandler<? super TcpChannel> ioHandler) {
            if (this.closed.get()) {
                throw new IllegalStateException("Connector closed");
            }
            return this.realConnector.connectTo(src, dest, ioHandler);
        }

        @Override
        public TcpChannelSource createChannelSource(final SocketAddress dest) {
            return new TcpChannelSource(){

                @Override
                public IoFuture<TcpChannel> open(IoHandler<? super TcpChannel> handler) {
                    return LifecycleConnector.this.realConnector.connectTo(dest, handler);
                }
            };
        }

        @Override
        public TcpChannelSource createChannelSource(final SocketAddress src, final SocketAddress dest) {
            return new TcpChannelSource(){

                @Override
                public IoFuture<TcpChannel> open(IoHandler<? super TcpChannel> handler) {
                    return LifecycleConnector.this.realConnector.connectTo(src, dest, handler);
                }
            };
        }
    }

    private class LifecycleCloseable
    implements Closeable {
        private final Lifecycle lifecycle;
        private final AtomicBoolean closed;

        private LifecycleCloseable(Lifecycle lifecycle, AtomicBoolean closed) {
            this.closed = closed;
            this.lifecycle = lifecycle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                Object object = NioXnio.this.lifecycleLock;
                synchronized (object) {
                    this.lifecycle.stop();
                }
            }
        }
    }
}

