/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.HashMap;
import java.util.HashSet;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.casemgmt.cmmn.core.PlanItem;
import org.jbpm.casemgmt.cmmn.core.Sentry;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.workflow.core.NodeContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PlanItemHandler
extends BaseAbstractHandler
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(PlanItemHandler.class);

    public PlanItemHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(NodeContainer.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(PlanItem.class);
            this.validPeers.add(Sentry.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String definitionRef = attrs.getValue("definitionRef");
        logger.debug("Found plan item with id {} and definitionRef {}", (Object)id, (Object)definitionRef);
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        HashMap<String, PlanItem> planItems = (HashMap<String, PlanItem>)buildData.getMetaData("PlanItems");
        if (planItems == null) {
            planItems = new HashMap<String, PlanItem>();
            buildData.setMetaData("PlanItems", planItems);
        }
        PlanItem planItem = new PlanItem(id, definitionRef);
        planItems.put(definitionRef, planItem);
        return planItem;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        PlanItem planItem = (PlanItem)parser.getCurrent();
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        HashMap<String, Sentry> sentries = (HashMap<String, Sentry>)buildData.getMetaData("Sentries");
        if (sentries == null) {
            sentries = new HashMap<String, Sentry>();
            buildData.setMetaData("Sentries", sentries);
        }
        for (Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            Sentry sentryStubTmp;
            Sentry sentryStub;
            String nodeName = xmlNode.getNodeName();
            if ("entryCriterion".equals(nodeName)) {
                sentryStub = this.readSentry(xmlNode, planItem);
                sentryStubTmp = sentries.putIfAbsent(sentryStub.getId(), sentryStub);
                if (sentryStubTmp != null) {
                    sentryStub = sentryStubTmp;
                }
                planItem.setEntryCriterion(sentryStub);
                continue;
            }
            if (!"exitCriterion".equals(nodeName)) continue;
            sentryStub = this.readSentry(xmlNode, planItem);
            sentryStubTmp = sentries.putIfAbsent(sentryStub.getId(), sentryStub);
            if (sentryStubTmp != null) {
                sentryStub = sentryStubTmp;
            }
            planItem.setExitCriterion(sentryStub);
        }
        return planItem;
    }

    private Sentry readSentry(Node xmlNode, PlanItem planItem) {
        String sentryRef = ((Element)xmlNode).getAttribute("sentryRef");
        return new Sentry(sentryRef, null, null);
    }

    public Class<?> generateNodeFor() {
        return PlanItem.class;
    }
}

