/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn;

import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.io.ResourceFactory;

public abstract class AbstractCmmnBaseTest {
    protected KieBase createKnowledgeBase(String ... cases) throws Exception {
        Resource[] resources = new Resource[cases.length];
        for (int i = 0; i < cases.length; ++i) {
            String p = cases[i];
            resources[i] = ResourceFactory.newClassPathResource((String)p);
        }
        return this.createKnowledgeBaseFromResources(resources);
    }

    protected KieBase createKnowledgeBaseFromResources(Resource ... cases) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        if (cases.length > 0) {
            KieFileSystem kfs = ks.newKieFileSystem();
            for (Resource c : cases) {
                kfs.write(c);
            }
            KieBuilder kb = ks.newKieBuilder(kfs);
            kb.buildAll();
            if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
            }
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        return kContainer.getKieBase();
    }
}

