/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.casemgmt.cmmn.core.PlanItem;
import org.jbpm.casemgmt.cmmn.core.Sentry;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractCaseNodeHandler
extends BaseAbstractHandler
implements Handler {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractCaseNodeHandler.class);

    public AbstractCaseNodeHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = true;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(NodeContainer.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(PlanItem.class);
        this.validPeers.add(Sentry.class);
        this.validPeers.add(HumanTaskNode.class);
        this.validPeers.add(MilestoneNode.class);
        this.validPeers.add(DynamicNode.class);
        this.validPeers.add(SubProcessNode.class);
        this.validPeers.add(WorkItemNode.class);
        this.validPeers.add(RuleSetNode.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        Node node = this.createNode(attrs);
        String id = attrs.getValue("id");
        node.setMetaData("UniqueId", (Object)id);
        String name = attrs.getValue("name");
        node.setName(name);
        AtomicInteger idGen = (AtomicInteger)parser.getMetaData().get("idGen");
        node.setId((long)idGen.getAndIncrement());
        return node;
    }

    protected abstract Node createNode(Attributes var1);

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        Map planItems = (Map)buildData.getMetaData("PlanItems");
        PlanItem planItem = (PlanItem)planItems.get(node.getMetaData().get("UniqueId"));
        if (planItem != null && planItem.getEntryCriterion() != null) {
            if ("autostart".equalsIgnoreCase(planItem.getEntryCriterion().getExpression())) {
                node.setMetaData("customAutoStart", (Object)"true");
            } else {
                node.setMetaData("customActivationExpression", (Object)planItem.getEntryCriterion().getExpression());
                node.setMetaData("customActivationFragmentName", (Object)node.getName());
            }
        }
        this.handleNode(node, element, uri, localName, parser);
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((org.kie.api.definition.process.Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
    }

    protected void loadDataInputsAndOutputs(Element element, Map<String, String> inputs, Map<String, String> outputs, Map<String, String> inputTypes, Map<String, String> outputTypes, ExtensibleXmlParser parser) {
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        Map fileItems = (Map)buildData.getMetaData("FileItems");
        if (fileItems == null) {
            return;
        }
        Object parent = parser.getParent();
        if (parent instanceof ContextContainer) {
            ContextContainer contextContainer = (ContextContainer)parent;
            VariableScope variableScope = (VariableScope)contextContainer.getDefaultContext("VariableScope");
            for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
                Variable var;
                String varName;
                String bindingRef;
                String nodeName = xmlNode.getNodeName();
                if ("input".equals(nodeName)) {
                    String inputName = ((Element)xmlNode).getAttribute("name");
                    bindingRef = ((Element)xmlNode).getAttribute("bindingRef");
                    varName = "caseFile_" + (String)fileItems.get(bindingRef);
                    inputs.put(inputName, varName);
                    var = variableScope.findVariable(varName);
                    inputTypes.put(inputName, var.getType().getStringType());
                    continue;
                }
                if (!"output".equals(nodeName)) continue;
                String outputName = ((Element)xmlNode).getAttribute("name");
                bindingRef = ((Element)xmlNode).getAttribute("bindingRef");
                varName = "caseFile_" + (String)fileItems.get(bindingRef);
                outputs.put(outputName, varName);
                var = variableScope.findVariable(varName);
                inputTypes.put(outputName, var.getType().getStringType());
            }
        }
    }
}

