/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.impl.factories.TaskFactory;
import org.junit.Assert;
import org.junit.Test;

public abstract class SubTasksBaseTest
extends BaseTest {
    @Test
    public void noActionStrategy() throws Exception {
        String parentTaskstr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        parentTaskstr = parentTaskstr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('salaboy')  ], }),";
        parentTaskstr = parentTaskstr + "names = [ new I18NText( 'en-UK', 'This is my task Parent name')] })";
        Task parentTask = TaskFactory.evalTask((Reader)new StringReader(parentTaskstr));
        this.taskService.addTask(parentTask, new HashMap());
        long taskParentId = parentTask.getId();
        Task parentTask1 = this.taskService.getTaskById(taskParentId);
        Assert.assertEquals((Object)parentTask1.getTaskData().getStatus(), (Object)Status.Reserved);
        this.taskService.start(taskParentId, "salaboy");
        String child1Taskstr = "(with (new Task()) { priority = 55,  taskData = (with( new TaskData()) { parentId= " + taskParentId + " } ), ";
        child1Taskstr = child1Taskstr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Darth Vader')  ], }),";
        child1Taskstr = child1Taskstr + "names = [ new I18NText( 'en-UK', 'This is my task Child 1 name')] })";
        Task child1Task = TaskFactory.evalTask((Reader)new StringReader(child1Taskstr));
        this.taskService.addTask(child1Task, new HashMap());
        long child1TaskId = child1Task.getId();
        Assert.assertEquals((long)1L, (long)this.taskService.getPendingSubTasksByParent(taskParentId));
        Task childTask1 = this.taskService.getTaskById(child1TaskId);
        Assert.assertEquals((long)taskParentId, (long)childTask1.getTaskData().getParentId());
        this.taskService.start(child1TaskId, "Darth Vader");
        this.taskService.complete(child1TaskId, "Darth Vader", null);
        childTask1 = this.taskService.getTaskById(child1TaskId);
        Assert.assertEquals((Object)Status.Completed, (Object)childTask1.getTaskData().getStatus());
        parentTask1 = this.taskService.getTaskById(taskParentId);
        Assert.assertEquals((Object)Status.InProgress, (Object)parentTask1.getTaskData().getStatus());
        Assert.assertEquals((long)0L, (long)this.taskService.getPendingSubTasksByParent(taskParentId));
        this.taskService.complete(taskParentId, "salaboy", null);
        parentTask1 = this.taskService.getTaskById(taskParentId);
        Assert.assertEquals((Object)Status.Completed, (Object)parentTask1.getTaskData().getStatus());
    }

    @Test
    public void onSubtaskCompletionAutoCompleteParentStrategy() throws Exception {
        String parentTaskstr = "(with (new Task()) { subTaskStrategy = SubTasksStrategy.EndParentOnAllSubTasksEnd,  priority = 55, taskData = (with( new TaskData()) { } ), ";
        parentTaskstr = parentTaskstr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('salaboy')  ], }),";
        parentTaskstr = parentTaskstr + "names = [ new I18NText( 'en-UK', 'This is my task Parent name')] })";
        Task parentTask = TaskFactory.evalTask((Reader)new StringReader(parentTaskstr));
        this.taskService.addTask(parentTask, new HashMap());
        long taskParentId = parentTask.getId();
        Task parentTask1 = this.taskService.getTaskById(taskParentId);
        Assert.assertEquals((Object)parentTask1.getTaskData().getStatus(), (Object)Status.Reserved);
        this.taskService.start(taskParentId, "salaboy");
        String child1Taskstr = "(with (new Task()) { priority = 55,  taskData = (with( new TaskData()) { parentId= " + taskParentId + " } ), ";
        child1Taskstr = child1Taskstr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Darth Vader')  ], }),";
        child1Taskstr = child1Taskstr + "names = [ new I18NText( 'en-UK', 'This is my task Child 1 name')] })";
        Task child1Task = TaskFactory.evalTask((Reader)new StringReader(child1Taskstr));
        this.taskService.addTask(child1Task, new HashMap());
        long child1TaskId = child1Task.getId();
        Assert.assertEquals((long)1L, (long)this.taskService.getPendingSubTasksByParent(taskParentId));
        Task childTask1 = this.taskService.getTaskById(child1TaskId);
        Assert.assertEquals((long)taskParentId, (long)childTask1.getTaskData().getParentId());
        this.taskService.start(child1TaskId, "Darth Vader");
        this.taskService.complete(child1TaskId, "Darth Vader", null);
        childTask1 = this.taskService.getTaskById(child1TaskId);
        Assert.assertEquals((Object)Status.Completed, (Object)childTask1.getTaskData().getStatus());
        parentTask1 = this.taskService.getTaskById(taskParentId);
        Assert.assertEquals((long)0L, (long)this.taskService.getPendingSubTasksByParent(taskParentId));
        Assert.assertEquals((Object)Status.Completed, (Object)parentTask1.getTaskData().getStatus());
    }

    @Test
    public void onParentAbortCompleteAllSubTasksStrategy() throws Exception {
        String parentTaskstr = "(with (new Task()) { subTaskStrategy = SubTasksStrategy.SkipAllSubTasksOnParentSkip ,  priority = 55, taskData = (with( new TaskData()) { skipable = true } ), ";
        parentTaskstr = parentTaskstr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('salaboy')  ], }),";
        parentTaskstr = parentTaskstr + "names = [ new I18NText( 'en-UK', 'This is my task Parent name')] })";
        Task parentTask = TaskFactory.evalTask((Reader)new StringReader(parentTaskstr));
        this.taskService.addTask(parentTask, new HashMap());
        long taskParentId = parentTask.getId();
        Task parentTask1 = this.taskService.getTaskById(taskParentId);
        Assert.assertEquals((Object)parentTask1.getTaskData().getStatus(), (Object)Status.Reserved);
        this.taskService.start(taskParentId, "salaboy");
        String child1Taskstr = "(with (new Task()) { priority = 55,  taskData = (with( new TaskData()) { skipable = true, parentId= " + taskParentId + " } ), ";
        child1Taskstr = child1Taskstr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('Darth Vader')  ], }),";
        child1Taskstr = child1Taskstr + "names = [ new I18NText( 'en-UK', 'This is my task Child 1 name')] })";
        Task child1Task = TaskFactory.evalTask((Reader)new StringReader(child1Taskstr));
        this.taskService.addTask(child1Task, new HashMap());
        long child1TaskId = child1Task.getId();
        Assert.assertEquals((long)1L, (long)this.taskService.getPendingSubTasksByParent(taskParentId));
        Task childTask1 = this.taskService.getTaskById(child1TaskId);
        Assert.assertEquals((long)taskParentId, (long)childTask1.getTaskData().getParentId());
        this.taskService.start(child1TaskId, "Darth Vader");
        this.taskService.skip(taskParentId, "salaboy");
        parentTask1 = this.taskService.getTaskById(taskParentId);
        Assert.assertEquals((long)0L, (long)this.taskService.getPendingSubTasksByParent(taskParentId));
        Assert.assertEquals((Object)Status.Obsolete, (Object)parentTask1.getTaskData().getStatus());
        childTask1 = this.taskService.getTaskById(child1TaskId);
        Assert.assertEquals((Object)Status.Obsolete, (Object)childTask1.getTaskData().getStatus());
    }
}

