/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.jbpm.task.Group;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.User;
import org.jbpm.task.identity.LDAPUserInfoImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class LDAPUserInfoImplTest {
    @Test
    public void testGetEmailForUserEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getEmailForEntity((OrganizationalEntity)new User("john"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"john@jbpm.org", (Object)email);
    }

    @Test
    public void testGetEmailForGroupEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.email.attr.id", "ou");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getEmailForEntity((OrganizationalEntity)new Group("manager"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"managers@jbpm.org", (Object)email);
    }

    @Test
    public void testGetEmailForUserEntityAsDN() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.entity.id.dn", "true");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getEmailForEntity((OrganizationalEntity)new User("uid=john,ou=People,dc=jbpm,dc=org"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"john@jbpm.org", (Object)email);
    }

    @Test
    public void testGetEmailForGroupEntityAsDN() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.entity.id.dn", "true");
        properties.setProperty("ldap.email.attr.id", "ou");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getEmailForEntity((OrganizationalEntity)new Group("cn=manager,ou=Roles,dc=jbpm,dc=org"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"managers@jbpm.org", (Object)email);
    }

    @Test
    public void testGetGroupMembers() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.member.attr.id", "member");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        Iterator members = ldapUserInfo.getMembersForGroup(new Group("manager"));
        Assert.assertNotNull((Object)members);
        ArrayList<OrganizationalEntity> orgMembers = new ArrayList<OrganizationalEntity>();
        while (members.hasNext()) {
            OrganizationalEntity organizationalEntity = (OrganizationalEntity)members.next();
            orgMembers.add(organizationalEntity);
        }
        Assert.assertEquals((long)4L, (long)orgMembers.size());
    }

    @Test
    public void testGetNameForUserEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getDisplayName((OrganizationalEntity)new User("john"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"John Doe", (Object)email);
    }

    @Test
    public void testGetNameForGroupEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.name.attr.id", "description");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getDisplayName((OrganizationalEntity)new Group("manager"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"Manager group", (Object)email);
    }

    @Test
    public void testGetLangForUserEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getLanguageForEntity((OrganizationalEntity)new User("john"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"en-UK", (Object)email);
    }

    @Test
    public void testGetLangForGroupEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getLanguageForEntity((OrganizationalEntity)new Group("manager"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"en-UK", (Object)email);
    }
}

