/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.enterprise.inject.Alternative;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.kie.internal.task.api.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
public class LDAPUserGroupCallbackImpl
implements UserGroupCallback {
    private static final Logger logger = LoggerFactory.getLogger(LDAPUserGroupCallbackImpl.class);
    protected static final String DEFAULT_PROPERTIES_NAME = "/jbpm.usergroup.callback.properties";
    public static final String BIND_USER = "ldap.bind.user";
    public static final String BIND_PWD = "ldap.bind.pwd";
    public static final String USER_CTX = "ldap.user.ctx";
    public static final String ROLE_CTX = "ldap.role.ctx";
    public static final String USER_ROLES_CTX = "ldap.user.roles.ctx";
    public static final String USER_FILTER = "ldap.user.filter";
    public static final String ROLE_FILTER = "ldap.role.filter";
    public static final String USER_ROLES_FILTER = "ldap.user.roles.filter";
    public static final String USER_ATTR_ID = "ldap.user.attr.id";
    public static final String ROLE_ATTR_ID = "ldap.roles.attr.id";
    public static final String IS_USER_ID_DN = "ldap.user.id.dn";
    protected static final String[] requiredProperties = new String[]{"ldap.user.ctx", "ldap.role.ctx", "ldap.user.filter", "ldap.role.filter", "ldap.user.roles.filter"};
    private Properties config;

    public LDAPUserGroupCallbackImpl() {
        String propertiesLocation = System.getProperty("jbpm.usergroup.callback.properties");
        if (propertiesLocation == null) {
            propertiesLocation = DEFAULT_PROPERTIES_NAME;
        }
        logger.debug("Callback properties will be loaded from " + propertiesLocation);
        InputStream in = this.getClass().getResourceAsStream(propertiesLocation);
        if (in != null) {
            this.config = new Properties();
            try {
                this.config.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.config = null;
            }
        }
        this.validate();
    }

    public LDAPUserGroupCallbackImpl(Properties config) {
        this.config = config;
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsUser(String userId) {
        InitialLdapContext ctx = null;
        boolean exists = false;
        try {
            SearchControls constraints;
            NamingEnumeration<SearchResult> result;
            ctx = this.buildInitialLdapContext();
            String userContext = this.config.getProperty(USER_CTX);
            String userFilter = this.config.getProperty(USER_FILTER);
            String userAttrId = this.config.getProperty(USER_ATTR_ID, "uid");
            userFilter = userFilter.replaceAll("\\{0\\}", userId);
            if (logger.isDebugEnabled()) {
                logger.debug("Seaching for user existence with filter " + userFilter + " on context " + userContext);
            }
            if ((result = ctx.search(userContext, userFilter, constraints = new SearchControls())).hasMore()) {
                SearchResult sr = result.next();
                Attribute ldapUserId = sr.getAttributes().get(userAttrId);
                if (ldapUserId.contains(userId)) {
                    exists = true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Entry in LDAP found and result of matching with given user id is " + exists);
                }
            }
            result.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsGroup(String groupId) {
        InitialLdapContext ctx = null;
        boolean exists = false;
        try {
            SearchResult sr;
            Attribute ldapUserId;
            ctx = this.buildInitialLdapContext();
            String roleContext = this.config.getProperty(ROLE_CTX);
            String roleFilter = this.config.getProperty(ROLE_FILTER);
            String roleAttrId = this.config.getProperty(ROLE_ATTR_ID, "cn");
            roleFilter = roleFilter.replaceAll("\\{0\\}", groupId);
            SearchControls constraints = new SearchControls();
            NamingEnumeration<SearchResult> result = ctx.search(roleContext, roleFilter, constraints);
            if (result.hasMore() && (ldapUserId = (sr = result.next()).getAttributes().get(roleAttrId)).contains(groupId)) {
                exists = true;
            }
            result.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        InitialLdapContext ctx = null;
        ArrayList<String> userGroups = new ArrayList<String>();
        try {
            NamingEnumeration<SearchResult> result;
            ctx = this.buildInitialLdapContext();
            String userDN = null;
            if (!Boolean.parseBoolean(this.config.getProperty(IS_USER_ID_DN, "false"))) {
                NamingEnumeration<SearchResult> result2;
                if (logger.isDebugEnabled()) {
                    logger.debug("User id is not DN, looking up user first...");
                }
                String userContext = this.config.getProperty(USER_CTX);
                String userFilter = this.config.getProperty(USER_FILTER);
                userFilter = userFilter.replaceAll("\\{0\\}", userId);
                SearchControls constraints = new SearchControls();
                if (logger.isDebugEnabled()) {
                    logger.debug("Searching for user DN with filter " + userFilter + " on context " + userContext);
                }
                if ((result2 = ctx.search(userContext, userFilter, constraints)).hasMore()) {
                    SearchResult searchResult = (SearchResult)result2.nextElement();
                    userDN = searchResult.getNameInNamespace();
                    if (logger.isDebugEnabled()) {
                        logger.debug("User DN found, DN is " + userDN);
                    }
                }
                result2.close();
            }
            String roleContext = this.config.getProperty(USER_ROLES_CTX, ROLE_CTX);
            String roleFilter = this.config.getProperty(USER_ROLES_FILTER);
            String roleAttrId = this.config.getProperty(ROLE_ATTR_ID, "cn");
            roleFilter = roleFilter.replaceAll("\\{0\\}", userDN != null ? userDN : userId);
            SearchControls constraints = new SearchControls();
            if (logger.isDebugEnabled()) {
                logger.debug("Searching for groups for user with filter " + roleFilter + " on context " + roleContext);
            }
            if ((result = ctx.search(roleContext, roleFilter, constraints)).hasMore()) {
                SearchResult searchResult = null;
                String name = null;
                while (result.hasMore()) {
                    searchResult = (SearchResult)result.nextElement();
                    name = (String)searchResult.getAttributes().get(roleAttrId).get();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found group " + name);
                    }
                    userGroups.add(name);
                }
            }
            result.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return userGroups;
    }

    protected void validate() {
        if (this.config == null) {
            throw new IllegalArgumentException("No configuration found for LDAPUserGroupCallbackImpl, aborting...");
        }
        StringBuffer missingRequiredProps = new StringBuffer();
        for (String requiredProp : requiredProperties) {
            if (this.config.containsKey(requiredProp)) continue;
            if (missingRequiredProps.length() > 0) {
                missingRequiredProps.append(", ");
            }
            missingRequiredProps.append(requiredProp);
        }
        if (missingRequiredProps.length() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Validation failed due to missing required properties: " + missingRequiredProps.toString());
            }
            throw new IllegalArgumentException("Missing required properties to configure LDAPUserGroupCallbackImpl: " + missingRequiredProps.toString());
        }
    }

    protected InitialLdapContext buildInitialLdapContext() throws NamingException {
        String authType;
        String factoryName = this.config.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            this.config.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = this.config.getProperty("java.naming.security.authentication")) == null) {
            this.config.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = this.config.getProperty("java.naming.security.protocol");
        String providerURL = this.config.getProperty("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
            this.config.setProperty("java.naming.provider.url", providerURL);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Using following InitialLdapContext properties:");
            logger.debug("Factory " + this.config.getProperty("java.naming.factory.initial"));
            logger.debug("Authentication " + this.config.getProperty("java.naming.security.authentication"));
            logger.debug("Protocol " + this.config.getProperty("java.naming.security.protocol"));
            logger.debug("Provider URL " + this.config.getProperty("java.naming.provider.url"));
        }
        return new InitialLdapContext(this.config, null);
    }
}

