/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.User;
import org.jbpm.task.utils.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Embeddable
public class PeopleAssignments
implements Externalizable {
    @ManyToOne
    private User taskInitiator;
    @ManyToMany
    @JoinTable(name="PeopleAssignments_PotentialOwners", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")})
    private List<OrganizationalEntity> potentialOwners = Collections.emptyList();
    @ManyToMany
    @JoinTable(name="PeopleAssignments_ExcludedOwners", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")})
    private List<OrganizationalEntity> excludedOwners = Collections.emptyList();
    @ManyToMany
    @JoinTable(name="PeopleAssignments_TaskStakeholders", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")})
    private List<OrganizationalEntity> taskStakeholders = Collections.emptyList();
    @ManyToMany
    @JoinTable(name="PeopleAssignments_BusinessAdministrators", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")})
    private List<OrganizationalEntity> businessAdministrators = Collections.emptyList();
    @ManyToMany
    @JoinTable(name="PeopleAssignments_Recipients", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")})
    private List<OrganizationalEntity> recipients = Collections.emptyList();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.taskInitiator != null) {
            out.writeBoolean(true);
            this.taskInitiator.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        CollectionUtils.writeOrganizationalEntityList(this.potentialOwners, out);
        CollectionUtils.writeOrganizationalEntityList(this.excludedOwners, out);
        CollectionUtils.writeOrganizationalEntityList(this.taskStakeholders, out);
        CollectionUtils.writeOrganizationalEntityList(this.businessAdministrators, out);
        CollectionUtils.writeOrganizationalEntityList(this.recipients, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.taskInitiator = new User();
            this.taskInitiator.readExternal(in);
        }
        this.potentialOwners = CollectionUtils.readOrganizationalEntityList(in);
        this.excludedOwners = CollectionUtils.readOrganizationalEntityList(in);
        this.taskStakeholders = CollectionUtils.readOrganizationalEntityList(in);
        this.businessAdministrators = CollectionUtils.readOrganizationalEntityList(in);
        this.recipients = CollectionUtils.readOrganizationalEntityList(in);
    }

    public User getTaskInitiator() {
        return this.taskInitiator;
    }

    public void setTaskInitiator(User taskInitiator) {
        this.taskInitiator = taskInitiator;
    }

    public List<OrganizationalEntity> getPotentialOwners() {
        return this.potentialOwners;
    }

    public void setPotentialOwners(List<OrganizationalEntity> potentialOwners) {
        this.potentialOwners = potentialOwners;
    }

    public List<OrganizationalEntity> getExcludedOwners() {
        return this.excludedOwners;
    }

    public void setExcludedOwners(List<OrganizationalEntity> excludedOwners) {
        this.excludedOwners = excludedOwners;
    }

    public List<OrganizationalEntity> getTaskStakeholders() {
        return this.taskStakeholders;
    }

    public void setTaskStakeholders(List<OrganizationalEntity> taskStakeholders) {
        this.taskStakeholders = taskStakeholders;
    }

    public List<OrganizationalEntity> getBusinessAdministrators() {
        return this.businessAdministrators;
    }

    public void setBusinessAdministrators(List<OrganizationalEntity> businessAdministrators) {
        this.businessAdministrators = businessAdministrators;
    }

    public List<OrganizationalEntity> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<OrganizationalEntity> recipients) {
        this.recipients = recipients;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CollectionUtils.hashCode(this.businessAdministrators);
        result = 31 * result + CollectionUtils.hashCode(this.excludedOwners);
        result = 31 * result + CollectionUtils.hashCode(this.potentialOwners);
        result = 31 * result + CollectionUtils.hashCode(this.recipients);
        result = 31 * result + (this.taskInitiator == null ? 0 : this.taskInitiator.hashCode());
        result = 31 * result + CollectionUtils.hashCode(this.taskStakeholders);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeopleAssignments)) {
            return false;
        }
        PeopleAssignments other = (PeopleAssignments)obj;
        if (this.taskInitiator == null ? other.taskInitiator != null : !this.taskInitiator.equals(other.taskInitiator)) {
            return false;
        }
        return CollectionUtils.equals(this.businessAdministrators, other.businessAdministrators) && CollectionUtils.equals(this.excludedOwners, other.excludedOwners) && CollectionUtils.equals(this.potentialOwners, other.potentialOwners) && CollectionUtils.equals(this.recipients, other.recipients) && CollectionUtils.equals(this.taskStakeholders, other.taskStakeholders);
    }
}

