/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.process.workitem.email.EmailWorkItemHandler;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemManager;
import org.drools.util.ChainedProperties;
import org.drools.util.ClassLoaderUtil;
import org.jbpm.task.Content;
import org.jbpm.task.Deadline;
import org.jbpm.task.EmailNotification;
import org.jbpm.task.EmailNotificationHeader;
import org.jbpm.task.Escalation;
import org.jbpm.task.Group;
import org.jbpm.task.Notification;
import org.jbpm.task.NotificationType;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.TaskService;
import org.mvel2.MVEL;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEscalatedDeadlineHandler
implements EscalatedDeadlineHandler {
    private UserInfo userInfo;
    private String from;
    private String replyTo;
    EmailWorkItemHandler handler = new EmailWorkItemHandler();
    WorkItemManager manager;

    public DefaultEscalatedDeadlineHandler(Properties properties) {
        String host = properties.getProperty("mail.smtp.host", "localhost");
        String port = properties.getProperty("mail.smtp.port", "25");
        this.from = properties.getProperty("from", null);
        this.replyTo = properties.getProperty("replyTo", null);
        this.handler.setConnection(host, port, null, null);
    }

    public DefaultEscalatedDeadlineHandler() {
        ChainedProperties conf = new ChainedProperties("drools.email.conf", (ClassLoader)ClassLoaderUtil.getClassLoader(null, this.getClass(), (boolean)false));
        String host = conf.getProperty("host", null);
        String port = conf.getProperty("port", "25");
        this.from = conf.getProperty("from", null);
        this.replyTo = conf.getProperty("replyTo", null);
        this.handler.setConnection(host, port, null, null);
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public WorkItemManager getManager() {
        return this.manager;
    }

    public void setManager(WorkItemManager manager) {
        this.manager = manager;
    }

    @Override
    public void executeEscalatedDeadline(Task task, Deadline deadline, EntityManager em, TaskService service) {
        if (deadline == null || deadline.getEscalations() == null) {
            return;
        }
        for (Escalation escalation : deadline.getEscalations()) {
            String language = "en-UK";
            for (Notification notification : escalation.getNotifications()) {
                if (notification.getNotificationType() != NotificationType.Email) continue;
                this.executeEmailNotification((EmailNotification)notification, task, em);
            }
            if (escalation.getReassignments().isEmpty()) continue;
            Reassignment reassignment = escalation.getReassignments().get(0);
            em.getTransaction().begin();
            task.getTaskData().setStatus(Status.Ready);
            ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>(reassignment.getPotentialOwners());
            task.getPeopleAssignments().setPotentialOwners(potentialOwners);
            em.getTransaction().commit();
        }
        em.getTransaction().begin();
        deadline.setEscalated(true);
        em.getTransaction().commit();
    }

    public void executeEmailNotification(EmailNotification notification, Task task, EntityManager em) {
        Map<String, EmailNotificationHeader> headers = notification.getEmailHeaders();
        HashMap<String, List<User>> users = new HashMap<String, List<User>>();
        for (OrganizationalEntity entity : notification.getBusinessAdministrators()) {
            if (entity instanceof Group) {
                this.buildMapByLanguage(users, (Group)entity);
                continue;
            }
            this.buildMapByLanguage(users, (User)entity);
        }
        for (OrganizationalEntity entity : notification.getRecipients()) {
            if (entity instanceof Group) {
                this.buildMapByLanguage(users, (Group)entity);
                continue;
            }
            this.buildMapByLanguage(users, (User)entity);
        }
        TaskData taskData = task.getTaskData();
        Map doc = null;
        if (taskData != null) {
            Content content = (Content)em.find(Content.class, (Object)taskData.getDocumentContentId());
            if (content != null) {
                ExpressionCompiler compiler = new ExpressionCompiler(new String(content.getContent()));
                doc = (Map)MVEL.executeExpression((Object)compiler.compile());
            } else {
                doc = Collections.emptyMap();
            }
        }
        for (Map.Entry entry : users.entrySet()) {
            EmailNotificationHeader header = headers.get(entry.getKey());
            HashMap<String, String> email = new HashMap<String, String>();
            StringBuilder to = new StringBuilder();
            boolean first = true;
            for (User user : (List)entry.getValue()) {
                if (!first) {
                    to.append(';');
                }
                String emailAddress = this.userInfo.getEmailForEntity(user);
                to.append(emailAddress);
                first = false;
            }
            email.put("To", to.toString());
            if (header.getFrom() != null && header.getFrom().trim().length() > 0) {
                email.put("From", header.getFrom());
            } else {
                email.put("From", this.from);
            }
            if (header.getReplyTo() != null && header.getReplyTo().trim().length() > 0) {
                email.put("Reply-To", header.getReplyTo());
            } else {
                email.put("Reply-To", this.replyTo);
            }
            HashMap<String, Map> vars = new HashMap<String, Map>();
            vars.put("doc", doc);
            String subject = (String)TemplateRuntime.eval((String)header.getSubject(), vars);
            String body = (String)TemplateRuntime.eval((String)header.getBody(), vars);
            email.put("Subject", subject);
            email.put("Body", body);
            WorkItemImpl workItem = new WorkItemImpl();
            workItem.setParameters(email);
            this.handler.executeWorkItem((WorkItem)workItem, this.manager);
        }
    }

    private void buildMapByLanguage(Map<String, List<User>> map, Group group) {
        Iterator<OrganizationalEntity> it = this.userInfo.getMembersForGroup(group);
        while (it.hasNext()) {
            OrganizationalEntity entity = it.next();
            if (entity instanceof Group) {
                this.buildMapByLanguage(map, (Group)entity);
                continue;
            }
            this.buildMapByLanguage(map, (User)entity);
        }
    }

    private void buildMapByLanguage(Map<String, List<User>> map, User user) {
        String language = this.userInfo.getLanguageForEntity(user);
        List<User> list = map.get(language);
        if (list == null) {
            list = new ArrayList<User>();
            map.put(language, list);
        }
        list.add(user);
    }
}

