/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.SystemEventListener;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.task.Attachment;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.Task;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.Command;
import org.jbpm.task.service.CommandName;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.EventTransport;
import org.jbpm.task.service.Operation;
import org.jbpm.task.service.SessionWriter;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;

public class TaskServerHandler {
    private final TaskService service;
    private final Map<String, SessionWriter> clients;
    private final SystemEventListener systemEventListener;

    public TaskServerHandler(TaskService service, SystemEventListener systemEventListener) {
        this.service = service;
        this.clients = new HashMap<String, SessionWriter>();
        this.systemEventListener = systemEventListener;
    }

    public void exceptionCaught(SessionWriter session, Throwable cause) throws Exception {
        this.systemEventListener.exception("Uncaught exception on Server", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageReceived(SessionWriter session, Object message) throws Exception {
        Command cmd = (Command)message;
        TaskServiceSession taskSession = this.service.createSession();
        CommandName response = null;
        try {
            this.systemEventListener.debug("Message receieved on server : " + (Object)((Object)cmd.getName()));
            this.systemEventListener.debug("Arguments : " + Arrays.toString(cmd.getArguments().toArray()));
            switch (cmd.getName()) {
                case OperationRequest: {
                    response = CommandName.OperationResponse;
                    Operation operation = (Operation)((Object)cmd.getArguments().get(0));
                    this.systemEventListener.debug("Command receieved on server was operation of type: " + (Object)((Object)operation));
                    long taskId = (Long)cmd.getArguments().get(1);
                    String userId = (String)cmd.getArguments().get(2);
                    String targetEntityId = null;
                    ContentData data = null;
                    List groupIds = null;
                    if (cmd.getArguments().size() > 3) {
                        targetEntityId = (String)cmd.getArguments().get(3);
                        if (cmd.getArguments().size() > 4) {
                            data = (ContentData)cmd.getArguments().get(4);
                            if (cmd.getArguments().size() > 5) {
                                groupIds = (List)cmd.getArguments().get(5);
                            }
                        }
                    }
                    taskSession.taskOperation(operation, taskId, userId, targetEntityId, data, groupIds);
                    List<Object> args = Collections.emptyList();
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.OperationResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case GetTaskRequest: {
                    response = CommandName.GetTaskResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    Task task = taskSession.getTask(taskId);
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(task);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.GetTaskResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case AddTaskRequest: {
                    response = CommandName.AddTaskResponse;
                    Task task = (Task)cmd.getArguments().get(0);
                    ContentData content = (ContentData)cmd.getArguments().get(1);
                    taskSession.addTask(task, content);
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(task.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.AddTaskResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case AddCommentRequest: {
                    response = CommandName.AddCommentResponse;
                    Comment comment = (Comment)cmd.getArguments().get(1);
                    taskSession.addComment((Long)cmd.getArguments().get(0), comment);
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(comment.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.AddCommentResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case DeleteCommentRequest: {
                    response = CommandName.DeleteCommentResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    long commentId = (Long)cmd.getArguments().get(1);
                    taskSession.deleteComment(taskId, commentId);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.DeleteCommentResponse, Collections.<Object>emptyList());
                    session.write(resultsCmnd);
                    return;
                }
                case AddAttachmentRequest: {
                    response = CommandName.AddAttachmentResponse;
                    Attachment attachment = (Attachment)cmd.getArguments().get(1);
                    Content content = (Content)cmd.getArguments().get(2);
                    taskSession.addAttachment((Long)cmd.getArguments().get(0), attachment, content);
                    ArrayList<Object> args = new ArrayList<Object>(2);
                    args.add(attachment.getId());
                    args.add(content.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.AddAttachmentResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case DeleteAttachmentRequest: {
                    response = CommandName.DeleteAttachmentResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    long attachmentId = (Long)cmd.getArguments().get(1);
                    long contentId = (Long)cmd.getArguments().get(2);
                    taskSession.deleteAttachment(taskId, attachmentId, contentId);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.DeleteAttachmentResponse, Collections.<Object>emptyList());
                    session.write(resultsCmnd);
                    return;
                }
                case SetDocumentContentRequest: {
                    response = CommandName.SetDocumentContentResponse;
                    long taskId = (Long)cmd.getArguments().get(0);
                    Content content = (Content)cmd.getArguments().get(1);
                    taskSession.setDocumentContent(taskId, content);
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(content.getId());
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.SetDocumentContentResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case GetContentRequest: {
                    response = CommandName.GetContentResponse;
                    long contentId = (Long)cmd.getArguments().get(0);
                    Content content = taskSession.getContent(contentId);
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(content);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.GetContentResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTaskByWorkItemId: {
                    response = CommandName.QueryTaskByWorkItemIdResponse;
                    Task result = taskSession.getTaskByWorkItemId((Long)cmd.getArguments().get(0));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(result);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskByWorkItemIdResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksOwned: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksOwned((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsBusinessAdministrator: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsBusinessAdministrator((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwner: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsPotentialOwner((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwnerWithGroup: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsPotentialOwner((String)cmd.getArguments().get(0), (List)cmd.getArguments().get(1), (String)cmd.getArguments().get(2));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsPotentialOwnerByGroup: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsPotentialOwnerByGroup((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QuerySubTasksAssignedAsPotentialOwner: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getSubTasksAssignedAsPotentialOwner((Long)cmd.getArguments().get(0), (String)cmd.getArguments().get(1), (String)cmd.getArguments().get(2));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryGetSubTasksByParentTaskId: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getSubTasksByParent((Long)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsTaskInitiator: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsTaskInitiator((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsExcludedOwner: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsExcludedOwner((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsRecipient: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsRecipient((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case QueryTasksAssignedAsTaskStakeholder: {
                    response = CommandName.QueryTaskSummaryResponse;
                    List<TaskSummary> results = taskSession.getTasksAssignedAsTaskStakeholder((String)cmd.getArguments().get(0), (String)cmd.getArguments().get(1));
                    ArrayList<Object> args = new ArrayList<Object>(1);
                    args.add(results);
                    Command resultsCmnd = new Command(cmd.getId(), CommandName.QueryTaskSummaryResponse, args);
                    session.write(resultsCmnd);
                    return;
                }
                case RegisterForEventRequest: {
                    response = CommandName.EventTriggerResponse;
                    EventKey key = (EventKey)cmd.getArguments().get(0);
                    boolean remove = (Boolean)cmd.getArguments().get(1);
                    String uuid = (String)cmd.getArguments().get(2);
                    this.clients.put(uuid, session);
                    EventTransport transport = new EventTransport(uuid, cmd.getId(), this.clients, remove);
                    this.service.getEventKeys().register(key, transport);
                    return;
                }
                case RegisterClient: {
                    String uuid = (String)cmd.getArguments().get(0);
                    this.clients.put(uuid, session);
                    return;
                }
                default: {
                    this.systemEventListener.debug("Unknown command recieved on server");
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            this.systemEventListener.exception(e.getMessage(), (Throwable)e);
            e.printStackTrace(System.err);
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(e);
            Command resultsCmnd = new Command(cmd.getId(), response, list);
            session.write(resultsCmnd);
            return;
        }
        finally {
            taskSession.dispose();
        }
    }
}

