/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.jbpm.task.service.TaskServer;

public class BaseMinaTaskServer
extends TaskServer {
    private final int port;
    IoHandlerAdapter handler;
    IoAcceptor acceptor;
    volatile boolean running;

    public BaseMinaTaskServer(IoHandlerAdapter handler, int port) {
        this.handler = handler;
        this.port = port;
    }

    public void run() {
        try {
            this.start();
            while (this.running) {
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Server Exception with class " + this.getClass() + " using port " + this.port, e);
        }
    }

    public void start() throws IOException {
        this.acceptor = new NioSocketAcceptor();
        this.acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        this.acceptor.setHandler((IoHandler)this.handler);
        this.acceptor.getSessionConfig().setReadBufferSize(2048);
        this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
        this.acceptor.bind((SocketAddress)new InetSocketAddress("127.0.0.1", this.port));
        this.running = true;
    }

    public IoAcceptor getIoAcceptor() {
        return this.acceptor;
    }

    public void stop() {
        this.running = false;
        this.acceptor.dispose();
    }

    public boolean isRunning() {
        return this.running;
    }
}

