/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.jbpm.task.User;

@Entity
@Table(name="task_comment")
public class Comment
implements Externalizable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Lob
    private String text;
    @ManyToOne
    private User addedBy;
    private Date addedAt;

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeUTF(this.text);
        this.addedBy.writeExternal(out);
        out.writeLong(this.addedAt.getTime());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.text = in.readUTF();
        this.addedBy = new User();
        this.addedBy.readExternal(in);
        this.addedAt = new Date(in.readLong());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getAddedAt() {
        return this.addedAt;
    }

    public void setAddedAt(Date addedDate) {
        this.addedAt = addedDate;
    }

    public User getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(User addedBy) {
        this.addedBy = addedBy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addedBy == null ? 0 : this.addedBy.hashCode());
        result = 31 * result + (this.addedAt == null ? 0 : this.addedAt.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)obj;
        if (this.addedBy == null ? other.addedBy != null : !this.addedBy.equals(other.addedBy)) {
            return false;
        }
        if (this.addedAt == null ? other.addedAt != null : this.addedAt.getTime() != other.addedAt.getTime()) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

