/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.jodconverter.office.AbstractOfficeManagerPoolEntry;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManagerPoolEntryConfig;
import org.jodconverter.office.OnlineOfficeConnection;
import org.jodconverter.office.OnlineOfficeManagerPoolEntryConfig;
import org.jodconverter.office.RequestConfig;
import org.jodconverter.ssl.SslConfig;
import org.jodconverter.task.OfficeTask;

class OnlineOfficeManagerPoolEntry
extends AbstractOfficeManagerPoolEntry {
    private final String connectionUrl;
    private final SslConfig sslConfig;

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = OnlineOfficeManagerPoolEntry.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    private static File getFile(URL url) {
        try {
            return new File(new URI(StringUtils.replace((String)url.toString(), (String)" ", (String)"%20")).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(url.getFile());
        }
    }

    private static File getFile(String resourceLocation) throws FileNotFoundException {
        Validate.notNull((Object)resourceLocation, (String)"Resource location must not be null", (Object[])new Object[0]);
        if (resourceLocation.startsWith("classpath:")) {
            URL url;
            String path = resourceLocation.substring("classpath:".length());
            String description = "class path resource [" + path + "]";
            ClassLoader cl = OnlineOfficeManagerPoolEntry.getDefaultClassLoader();
            URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not exist");
            }
            return OnlineOfficeManagerPoolEntry.getFile(url.toString());
        }
        try {
            return OnlineOfficeManagerPoolEntry.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    public OnlineOfficeManagerPoolEntry(String connectionUrl, SslConfig sslConfig, OnlineOfficeManagerPoolEntryConfig config) {
        super((OfficeManagerPoolEntryConfig)config);
        this.connectionUrl = connectionUrl;
        this.sslConfig = sslConfig;
    }

    private String buildUrl(String connectionUrl) throws MalformedURLException {
        URL url = new URL(connectionUrl);
        String path = url.toExternalForm().toLowerCase();
        if (StringUtils.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"lool/convert-to", "lool/convert-to/"})) {
            return StringUtils.appendIfMissing((String)connectionUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        if (StringUtils.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"lool", "lool/"})) {
            return StringUtils.appendIfMissing((String)connectionUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "convert-to/";
        }
        return StringUtils.appendIfMissing((String)connectionUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "lool/convert-to/";
    }

    private void configureKeyMaterial(SSLContextBuilder sslBuilder) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, NoSuchProviderException {
        KeyStore keystore = this.loadStore(this.sslConfig.getKeyStore(), this.sslConfig.getKeyStorePassword(), this.sslConfig.getKeyStoreType(), this.sslConfig.getKeyStoreProvider());
        if (keystore != null) {
            sslBuilder.loadKeyMaterial(keystore, this.sslConfig.getKeyPassword() != null ? this.sslConfig.getKeyPassword().toCharArray() : this.sslConfig.getKeyStorePassword().toCharArray(), (PrivateKeyStrategy)(this.sslConfig.getKeyAlias() == null ? null : new SelectByAlias(this.sslConfig.getKeyAlias())));
        }
    }

    private SSLConnectionSocketFactory configureSsl() throws OfficeException {
        if (this.sslConfig == null || !this.sslConfig.isEnabled()) {
            return null;
        }
        try {
            SSLContextBuilder sslBuilder = SSLContexts.custom();
            sslBuilder.setProtocol(this.sslConfig.getProtocol());
            this.configureKeyMaterial(sslBuilder);
            this.configureTrustMaterial(sslBuilder);
            SSLContext sslcontext = sslBuilder.build();
            return new SSLConnectionSocketFactory(sslcontext, this.sslConfig.getEnabledProtocols(), this.sslConfig.getCiphers(), this.sslConfig.isVerifyHostname() ? SSLConnectionSocketFactory.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException ex) {
            throw new OfficeException("Unable to create SSL context.", (Throwable)ex);
        }
    }

    private void configureTrustMaterial(SSLContextBuilder sslBuilder) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, NoSuchProviderException {
        KeyStore truststore = this.loadStore(this.sslConfig.getTrustStore(), this.sslConfig.getTrustStorePassword(), this.sslConfig.getTrustStoreType(), this.sslConfig.getTrustStoreProvider());
        if (truststore != null) {
            sslBuilder.loadTrustMaterial(truststore, null);
        }
    }

    protected void doExecute(OfficeTask task) throws OfficeException {
        SSLConnectionSocketFactory sslFactory = this.configureSsl();
        try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslFactory).build();){
            RequestConfig requestConfig = new RequestConfig(this.buildUrl(this.connectionUrl), Math.toIntExact(this.config.getTaskExecutionTimeout()), Math.toIntExact(this.config.getTaskExecutionTimeout()));
            task.execute((OfficeContext)new OnlineOfficeConnection(httpClient, requestConfig));
        }
        catch (IOException ex) {
            throw new OfficeException("Unable to create the HTTP client", (Throwable)ex);
        }
    }

    protected void doStart() throws OfficeException {
        this.taskExecutor.setAvailable(true);
    }

    protected void doStop() throws OfficeException {
    }

    private KeyStore loadStore(String store, String storePassword, String storeType, String storeProvider) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException {
        if (store != null) {
            Validate.notNull((Object)storePassword, (String)"The password of store {0} must not be null", (Object[])new Object[]{store});
            String type = storeType == null ? KeyStore.getDefaultType() : storeType;
            KeyStore keyStore = storeProvider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, storeProvider);
            try (FileInputStream instream = new FileInputStream(OnlineOfficeManagerPoolEntry.getFile(store));){
                keyStore.load(instream, storePassword.toCharArray());
            }
            return keyStore;
        }
        return null;
    }

    private static final class SelectByAlias
    implements PrivateKeyStrategy {
        private final String keyAlias;

        public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
            return aliases.keySet().stream().filter(key -> StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)this.keyAlias)).findFirst().orElse(null);
        }

        public SelectByAlias(String keyAlias) {
            this.keyAlias = keyAlias;
        }
    }
}

