/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.task;

import java.io.File;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.jodconverter.job.SourceDocumentSpecs;
import org.jodconverter.job.TargetDocumentSpecs;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OnlineOfficeContext;
import org.jodconverter.office.RequestConfig;
import org.jodconverter.task.AbstractOnlineOfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineConversionTask
extends AbstractOnlineOfficeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineConversionTask.class);
    private final TargetDocumentSpecs target;

    public OnlineConversionTask(SourceDocumentSpecs source, TargetDocumentSpecs target) {
        super(source);
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OfficeContext context) throws OfficeException {
        LOGGER.info("Executing online conversion task...");
        OnlineOfficeContext onlineContext = (OnlineOfficeContext)context;
        File sourceFile = this.source.getFile();
        try {
            File targetFile = this.target.getFile();
            try {
                HttpEntity entity = MultipartEntityBuilder.create().addPart("data", (ContentBody)new FileBody(sourceFile)).build();
                RequestConfig requestConfig = onlineContext.getRequestConfig();
                URIBuilder uriBuilder = new URIBuilder(this.buildUrl(requestConfig.getUrl()));
                Optional.ofNullable(this.target.getFormat().getLoadProperties()).ifPresent(map -> map.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("FilterOptions")).forEach(entry -> uriBuilder.addParameter("loadOptions", entry.getValue().toString())));
                Optional.ofNullable(this.target.getFormat().getStoreProperties(this.source.getFormat().getInputFamily())).ifPresent(map -> map.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("FilterOptions")).forEach(entry -> uriBuilder.addParameter("storeOptions", entry.getValue().toString())));
                Executor.newInstance((HttpClient)onlineContext.getHttpClient()).execute(Request.Post((URI)uriBuilder.build()).connectTimeout(requestConfig.getConnectTimeout()).socketTimeout(requestConfig.getSocketTimeout()).body(entity)).saveContent(targetFile);
                this.target.onComplete(targetFile);
            }
            catch (Exception ex) {
                LOGGER.error("Online conversion failed.", (Throwable)ex);
                OfficeException officeEx = new OfficeException("Online conversion failed", (Throwable)ex);
                this.target.onFailure(targetFile, (Exception)officeEx);
                throw officeEx;
            }
        }
        finally {
            this.source.onConsumed(sourceFile);
        }
    }

    private String buildUrl(String connectionUrl) {
        return StringUtils.appendIfMissing((String)connectionUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + this.target.getFormat().getExtension();
    }
}

