/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.boot.autoconfigure;

import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jodconverter.DocumentConverter;
import org.jodconverter.LocalConverter;
import org.jodconverter.boot.autoconfigure.JodConverterLocalProperties;
import org.jodconverter.office.LocalOfficeManager;
import org.jodconverter.office.OfficeManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={LocalConverter.class})
@ConditionalOnProperty(prefix="jodconverter.local", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={JodConverterLocalProperties.class})
public class JodConverterLocalAutoConfiguration {
    private final JodConverterLocalProperties properties;

    public JodConverterLocalAutoConfiguration(JodConverterLocalProperties properties) {
        this.properties = properties;
    }

    private OfficeManager createOfficeManager() {
        LocalOfficeManager.Builder builder = LocalOfficeManager.builder();
        if (!StringUtils.isBlank((CharSequence)this.properties.getPortNumbers())) {
            builder.portNumbers(ArrayUtils.toPrimitive((Integer[])((Integer[])Stream.of(StringUtils.split((String)this.properties.getPortNumbers(), (String)", ")).map(str -> NumberUtils.toInt((String)str, (int)2002)).toArray(Integer[]::new))));
        }
        builder.officeHome(this.properties.getOfficeHome());
        builder.workingDir(this.properties.getWorkingDir());
        builder.templateProfileDir(this.properties.getTemplateProfileDir());
        builder.killExistingProcess(this.properties.isKillExistingProcess());
        builder.processTimeout(this.properties.getProcessTimeout());
        builder.processRetryInterval(this.properties.getProcessRetryInterval());
        builder.taskExecutionTimeout(this.properties.getTaskExecutionTimeout());
        builder.maxTasksPerProcess(this.properties.getMaxTasksPerProcess());
        builder.taskQueueTimeout(this.properties.getTaskQueueTimeout());
        return builder.build();
    }

    @Bean(name={"localOfficeManager"}, initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean(name={"localOfficeManager"})
    public OfficeManager localOfficeManager() {
        return this.createOfficeManager();
    }

    @Bean
    @ConditionalOnMissingBean(name={"localDocumentConverter"})
    @ConditionalOnBean(name={"localOfficeManager"})
    public DocumentConverter localDocumentConverter(OfficeManager localOfficeManager) {
        return LocalConverter.make((OfficeManager)localOfficeManager);
    }
}

